/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
** Modified by : Nick Thompson (MMM yyyy)
** Modified by : David Mott (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/

#ifndef SO_ENGINE_OUTPUT_LIST_H
#define SO_ENGINE_OUTPUT_LIST_H

#include <Inventor/SbPList.h>

/**
 * Maintains a list of pointers to engine outputs.
 *
 * @ingroup engines
 *
 * @DESCRIPTION
 *   This subclass of SbPList holds lists of pointers to SoEngineOutputs. It updates
 *   reference counts to engine outputs in the list whenever adding or removing
 *   pointers.
 *
 * @SEE_ALSO
 *    SoEngineOutput
 *
 *
 * [OIV-WRAPPER-CUSTOM-CODE]
 */
class INVENTOR_API SoEngineOutputList : public SbPList
{
 public:
  /**
   * Constructor.
   */
  SoEngineOutputList(): SbPList() {}

  /**
   * Constructor that pre-allocates storage for @B size @b pointers.
   */
  SoEngineOutputList(int size) : SbPList(size) {}

  /**
   * Constructor that copies the contents of another list.
   */
  SoEngineOutputList(const SoEngineOutputList &l) : SbPList(l) {}

  /**
   * Destructor.
   */
  virtual ~SoEngineOutputList() {}

  /**
   * Adds an engine output to the end of the list.
   */
  void append(SoEngineOutput* engineOutput)
  { SbPList::append(static_cast<void*>(engineOutput)); }

  /**
   * Inserts the given engine output in the list before the element of the given
   * index.
   */
  void insert(SoEngineOutput* engineOutput, int addBefore)
  { SbPList::insert(static_cast<void*>(engineOutput), addBefore); }

  /** @copydoc SbPList::operator[]() */
  SoEngineOutput* operator [](int i) const
  { return ( static_cast<SoEngineOutput*> ( (* static_cast<const SbPList*>(this)) [i] ) ); }

  /**
   * Sets an element of a list.
   */
  void set(int i, SoEngineOutput* engineOutput)
  { SbPList::set( i, engineOutput); }
};

#endif

