/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
** Modified by : Nick Thompson (MMM yyyy)
** Modified by : David Mott (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/

#ifndef SO_NODE_LIST_H
#define SO_NODE_LIST_H

#include <Inventor/lists/SoBaseList.h>

class SoNode;

/**
 * Maintains a list of pointers to nodes.
 *
 * @ingroup nodes
 *
 * @DESCRIPTION
 *   This subclass of SoBaseList holds lists of pointers to SoNodes. It updates
 *   reference counts to nodes in the list whenever adding or removing pointers.
 *
 * @SEE_ALSO
 *    SoNode
 *
 *
 * [OIV-WRAPPER-CUSTOM-CODE]
 */
class INVENTOR_API SoNodeList : public SoBaseList
{
 public:
  /**
   * Constructor.
   */
  SoNodeList() : SoBaseList() {}

  /**
   * Constructor that pre-allocates storage for @B size @b pointers.
   */
  SoNodeList(int size) : SoBaseList(size) {}

  /**
   * Constructor that copies the contents of another list.
   */
  SoNodeList(const SoNodeList &l) : SoBaseList(l) {}

  /**
   * Destructor.
   */
  virtual ~SoNodeList() {}

  /**
   * Adds a pointer to the end of the list.
   */
  void append(SoNode * ptr)
  { SoBaseList::append((SoBase*)ptr); }

  /** @copydoc SoBaseList::operator[]() */
  SoNode * operator [](int i) const
  { return ((SoNode*) ((*(const SoBaseList *) this) [i])); }

  /**
   * Copies a list, keeping all reference counts correct.
   */
  SoNodeList &operator =(const SoNodeList &l)
  { SoBaseList::copy(l) ; return *this; }

};

#endif
