/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (SEP 2012)
**=======================================================================*/

#ifndef  _SO_LICENSES_PRODUCT_
#define  _SO_LICENSES_PRODUCT_

#include <Inventor/misc/SoRefCounter.h>
#include <Inventor/SbPImpl.h>
#include <Inventor/SbString.h>
#include <Inventor/sys/port.h>

class SoLicenseProperty;

SO_PIMPL_PUBLIC_DECLARATION(SoLicensesInfo)

SO_PIMPL_BASE_PUBLIC_DECLARATION(SoLicensedProduct)

/**
 * @VSGEXT Class managing a licensed product.
 *
 * @ingroup lock
 *
 * @DESCRIPTION
 *   SoLicensedProduct manages a licensed product.
 *   This class provides information about the current
 *   available licenses for a given product.
 *   The #getProduct() method returns the SbProduct enum value corresponding to the product.
 *   The #getLicenseCount() method gives you the number of licenses available.
 *   The #getLicenseByIndex() method gives you a SoLicenseProperty containing license info for this product.
 */
class INVENTORBASE_API SoLicensedProduct : public SoRefCounter
{
  SO_PIMPL_BASE_PUBLIC_HEADER(SoLicensedProduct)

public:

  /**
   * List of all available Open Inventor products.
   */
  enum SbProduct
  {
    // Open Inventor products
    OpenInventor = 0,
    HardCopy,
    MeshVizXLM,
    MeshViz,
    MeshVizInterface,
    MeshVizExtractor,
    VolumeVizLDM,
    VolumeViz,
    LDMWriter,
    AllInventor, /** Unlocks all Open Inventor products */

    // Readers from Datakit
    OivCatia5Reader,
    OivCatia6Reader,
    OivDxfReader, /** VSG Reader */
    OivDwgReader,
    OivIgesReader,
    OivJtReader,
    OivProeReader,
    OivSolidedgeReader,
    OivSolidworksReader,
    OivStepReader,
    OivUgReader,
    OivVdaReader,
    OivXmtReader,

    // Open Inventor Options
    IvTuneViewer,
    RemoteViz,
    ScaleVizCluster,
    ScaleVizWorkstation,

    NumberOfProducts
  };

  SoLicensedProduct();
  virtual ~SoLicensedProduct();

  /**
   * Returns the SbProduct enum value of the licensed product.
   */
  SbProduct getProduct() const;

  /**
   * Returns the name of the licensed product.
   */
  SbString getProductName() const;

  /**
   * Returns the number of licenses available for this product.
   */
  unsigned int getLicenseCount() const;

  /**
   * Returns the license of the licensed product for the given index.
   * If the given index is greater than the value returned
   * by #getLicenseCount(), the method returns NULL.
   */
  const SoLicenseProperty* getLicenseByIndex( unsigned int index ) const;

  friend class inventor::impl::SoLicensesInfoImpl;
};

#endif /* _SO_LICENSES_PRODUCT */
