/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef __SOLOCKMGR_H__
#define __SOLOCKMGR_H__

#include <Inventor/SbBase.h>

/**
 * @VSGEXT Sets the unlock string.
 * 
 * @ingroup lock
 * 
 * @DESCRIPTION
 * This class allows the application to set Master Password unlock strings programmatically.
 *
 * Only Master Password unlock strings can be used with this class. @BR
 * Temporary and floating license strings have a different format. These license strings can
 * be set, but will not unlock Open Inventor. They must be used with a license string file.
 *
 * Master Password strings embedded in application code must be "obfuscated" to
 * prevent them being easily extracted from the executable.  The application should remove
 * the obfuscation immediately before calling SetUnlockString().
 *
 * You must also ensure that the master password is not readable in the files you
 * redistribute.
 *
 * If your application uses any of the Open Inventor
 * extensions (e.g., MeshViz, VolumeViz, etc.), you must
 * specify the necessary license strings using a colon-separated list or a
 * newline-separated list. Effectively SoLockManager stores only a single 
 * string, so each call to the method SetUnlockString after the first one
 * overwrites the previously specified value. You must use the AppendUnlockString
 * method to add additional license strings after the initial call to SetUnlockString.
 * 
 * \if_cpp
 * You must set the unlock string before your call to SoXt::init, 
 * SoWin::init (Windows platforms only) or SoDB::init. 
 * \else
 * You must set the unlock string before any other call to OpenInventor framework.
 * \endif
 * This means the password string
 * should typically be specified in your application's main\if_cpp or WinMain \endif\.
 * [OIVNET-WRAPPER-CLASS STANDALONE]
 * [OIVJAVA-WRAPPER-NO-WRAP]
 */
class INVENTORBASE_API SoLockManager
{
 public:
	/**
	 * Sets the unlock string. @BR
	 * SoLockManager makes a copy of the specified string, so it is
	 * not necessary to declare a static string.@BR
	 * To reclaim the memory allocated by SoLockManager (for example
	 * at program exit), simply call setUnlockString with NULL.
	 */
	 static void SetUnlockString(char *pUnlockString);

   /**
    * Appends to the existing unlock string the specified string.
    * In order for the unlock string to be valid, each feature described
    * must be specified in a single line.
    */
   static void AppendUnlockString(const char *unlockString);

#if SoDEPRECATED_BEGIN(10400)
   /**
   * Returns the unlock string.
   * For security reason, this method always returns NULL.
   * @return NULL
   * [OIV-WRAPPER NO_WRAP]
   */
   SoDEPRECATED_METHOD(10400, "This method should no longer be used. It always returns NULL.")
     static char *GetUnlockString();
#endif /** @DEPRECATED_END */

	SoINTERNAL public:
	static void exitClass();
};

#endif
