/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul Isaacs (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_TAB_BOX_MANIP_
#define  _SO_TAB_BOX_MANIP_

#include <Inventor/manips/SoTransformManip.h>

/**
 * Transform node with 3D Interface for editing scale and translation.
 * 
 * @ingroup manips
 * 
 * @DESCRIPTION
 *   SoTabBoxManip is derived from SoTransform (by way of SoTransformManip). When its
 *   fields change, nodes following it in the scene graph scale, and/or translate.
 *   
 *   As a subclass of SoTransformManip, this manip also has a 3D interface to edit
 *   some of its fields. In this case, the interface edits the @B scaleFactor @b and
 *   @B translation @b fields.
 *   
 *   A manipulator differs from a dragger. When you move a dragger, no other nodes are
 *   affected. When you move an SoTransformManip, other nodes move along with it.
 *   (See the reference page for SoTransformManip.)
 *   
 *   The interface for an SoTabBoxManip is exactly the same as that of the
 *   SoTabBoxDragger. But note that SoTabBoxManip changes the default SoTabBoxDragger
 *   line color to a brighter gray.
 *
 *   - Clicking and dragging a @B corner tab @b does a 2D scaling in the plane of the tab by
 *     scaling about the opposite corner of that face of the dragger. @BR
 *     Note: Holding the @B SHIFT @b key while dragging a corner tab forces uniform
 *     scaling.
 *
 *   - Clicking and dragging an @B edge tab @b does 1D scaling about the opposite edge
 *     of that face.
 *
 *   - Clicking and dragging a @B face @b does translation within the plane of the face.
 *     Although the face of the dragger is invisible (using the default dragger geometry)
 *     it is pickable. @BR
 *     Note: Holding the @B SHIFT @b key while dragging a face forces axis constrained
 *     dragging. The drag axis is determined by the initial drag direction.
 *
 *   To find out how the manipulator uses a dragger to provide
 *   its interface, see the reference page for SoTransformManip.
 *   
 *   On screen, this manip will surround the objects influenced by its motion. This is
 *   because it turns on the @B surroundScale @b part of the dragger (See the
 *   reference page for SoSurroundScale)
 * 
 * @FILE_FORMAT_DEFAULT
 *    TabBoxManip {
 *    @TABLE_FILE_FORMAT
 *       @TR translation        @TD 0 0 0
 *       @TR rotation           @TD 0 0 1 0
 *       @TR scaleFactor        @TD 1 1 1
 *       @TR scaleOrientation   @TD 0 0 1 0
 *       @TR center             @TD 0 0 0
 *    @TABLE_END
 *    }
 * 
 * @SEE_ALSO
 *    SoCenterballManip,
 *    SoHandleBoxManip,
 *    SoJackManip,
 *    SoTabBoxDragger,
 *    SoTrackballManip,
 *    SoTransformBoxManip,
 *    SoTransformerManip,
 *    SoTransform,
 *    SoTransformManip
 * 
 * 
 */
class INVENTOR_API SoTabBoxManip : public SoTransformManip
{
  SO_NODE_HEADER(SoTabBoxManip);

 public:
  /**
   * Constructor.
   */
  SoTabBoxManip();

 SoINTERNAL public:
  static void initClass();  // initialize the class
  static void exitClass();

 protected:
  virtual ~SoTabBoxManip();
};    

#endif  /* _SO_TAB_BOX_MANIP_ */

