/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef SO_AUTO_REF_COUNTER_H
#define SO_AUTO_REF_COUNTER_H

#include <Inventor/SbBase.h>
#include <Inventor/misc/SoRefCounter.h>

/**
* Implements smart pointers to SoRefCounter objects.
* 
* @ingroup General
* 
* @DESCRIPTION
*
* This class implements smart pointers to SoRefCounter objects.
*
* @SEE_ALSO
*    SoRefCounter
*    SoRef
* 
* [OIV-WRAPPER-NO-WRAP]
*/
class SoAutoRef
{
public:
  /** Default constructor. */
  SoAutoRef()
  : m_pointer(nullptr)
  {}

  /** Copy constructor. */
  SoAutoRef(const SoAutoRef& that)
  : m_pointer(that.m_pointer)
  {
    if (m_pointer)
      m_pointer->ref();
  }

  /** Construct from C++ pointer. */
  SoAutoRef(SoRefCounter* pIn)
  : m_pointer(pIn)
  {
    if (m_pointer)
      m_pointer->ref();
  }

  /** Destructor. */
  ~SoAutoRef()
  {
    if (m_pointer)
      m_pointer->unref();
  }

  /** Assign another @c SoAutoRef. */
  SoAutoRef& operator=(const SoAutoRef& that)
  {
    (*this) = that.m_pointer;
    return *this;
  }

  /** Assign ordinary C pointer. */
  SoAutoRef& operator=(SoRefCounter* ptr)
  {
    if (m_pointer != ptr)
    {
      if (m_pointer)
        m_pointer->unref();
      m_pointer = ptr;
      if (m_pointer)
        m_pointer->ref();
    }
    return *this;
  }

  // Comparison operators with other SoAutoRef

  bool operator==(const SoAutoRef& other) const
  {
    return m_pointer == other.m_pointer;
  }

  bool operator!=(const SoAutoRef& other) const
  {
    return m_pointer != other.m_pointer;
  }

  bool operator<(const SoAutoRef& other) const
  {
    return m_pointer < other.m_pointer;
  }

  bool operator<=(const SoAutoRef& other) const
  {
    return m_pointer < other.m_pointer;
  }

  bool operator>(const SoAutoRef& other) const
  {
    return m_pointer > other.m_pointer;
  }

  bool operator>=(const SoAutoRef& other) const
  {
    return m_pointer > other.m_pointer;
  }

  // Comparison operators with SoRefCounter*

  bool operator==(const SoRefCounter* ptr) const
  {
    return m_pointer == ptr;
  }

  bool operator!=(const SoRefCounter* ptr) const
  {
    return m_pointer != ptr;
  }

  bool operator<(const SoRefCounter* ptr) const
  {
    return m_pointer < ptr;
  }

  bool operator<=(const SoRefCounter* ptr) const
  {
    return m_pointer < ptr;
  }

  bool operator>(const SoRefCounter* ptr) const
  {
    return m_pointer > ptr;
  }

  bool operator>=(const SoRefCounter* ptr) const
  {
    return m_pointer > ptr;
  }

  /** Conversion to boolean */
  operator bool() const
  {
    return get() != nullptr;
  }

  /** NOT operator */
  bool operator!() const
  {
    return get() == nullptr;
  }

  /** Dereference pointer. */
  SoRefCounter& operator*() const
  { return *(get()); }

  /** Cast to C pointer. */
  SoRefCounter* operator->() const
  { return get(); }

  /** Cast to C pointer. */
  SoRefCounter* ptr() const 
  { return get(); }

protected:
  SoRefCounter* get() const
  { return m_pointer; }

  /** handle the object pointer reference */
  SoRefCounter* m_pointer;
};

// Reverse comparison operators with SoRefCounter*
static inline bool operator==(const SoRefCounter* ptr, const SoAutoRef& ref)
{
  return ptr == ref.ptr();
}

static inline bool operator!=(const SoRefCounter* ptr, const SoAutoRef& ref)
{
  return ptr != ref.ptr();
}

static inline bool operator<(const SoRefCounter* ptr, const SoAutoRef& ref)
{
  return ptr < ref.ptr();
}

static inline bool operator<=(const SoRefCounter* ptr, const SoAutoRef& ref)
{
  return ptr <= ref.ptr();
}

static inline bool operator>(const SoRefCounter* ptr, const SoAutoRef& ref)
{
  return ptr > ref.ptr();
}

static inline bool operator>=(const SoRefCounter* ptr, const SoAutoRef& ref)
{
  return ptr >= ref.ptr();
}

// Included here to provide this service by default everywhere SoRefCounter 
// is already used, avoiding app to add a #include <Inventor/misc/SoAutoRef.h>
#include <Inventor/misc/SoRef.h>

#endif // SO_AUTO_REF_COUNTER_H


