/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/

#ifndef SOCOLORPACKER_H
#define SOCOLORPACKER_H

#include <Inventor/sys/port.h>
#include <Inventor/SbBase.h>
#include <Inventor/threads/SbThreadMutex.h>
#include <Inventor/SbColor.h>

class SoCpuBufferObject;

/**
 * Stores packed colors.
 *
 * @ingroup General
 *
 * @DESCRIPTION
 * This class is meant to be used by all property nodes that set either
 * a diffuse color or transparency in the lazy element. It maintains
 * a cache of the current diffuse color and transparency in a packed
 * color array.
 */
class INVENTOR_API SoColorPacker {

 public:

  //Constructor, makes a colorPacker with NULL packedColor pointer:
  SoColorPacker();

  // destructor, deletes packed color array
  ~SoColorPacker();

  /**
   * [OIV-WRAPPER-RETURN-TYPE ARRAY{GetSize()}]
   * [OIVJAVA-WRAPPER-RETURN-TYPE ARRAY{getSize()}]
   */
  uint32_t *getPackedColors() const {
    return packedColors;
  }
  SbBool diffuseMatch(uint64_t nodeId) {
    return (nodeId == diffuseNodeId);
  }
  SbBool transpMatch(uint64_t nodeId) {
    return (nodeId == transpNodeId);
  }
  void setNodeIds(uint64_t diffNodeId, uint64_t tNodeId) {
    diffuseNodeId = diffNodeId;
    transpNodeId = tNodeId;
  }
  int32_t getSize() {
    return packedArraySize;
  }
  void reallocate(int32_t size);

  static void exitClass();

SoINTERNAL public:
  /** Convert a set of big endian 32 bits ints to the system's endianness  */
  static SoCpuBufferObject* convertBigEndianToSystem(SoCpuBufferObject* source);

  /** Convert a big endian 32 bits packed color to a SbColor  */
  static void packedColorBigEndianToSbColor(SbColor& result, const uint32_t packedColor);

 private:

  // nodeids are used for testing cache validity
  uint64_t transpNodeId;
  uint64_t diffuseNodeId;
  // array of packed colors, or NULL if empty
  uint32_t *packedColors;
  // size of packed color array (not necessarily number of valid colors)
  int32_t packedArraySize;

  static SbThreadMutex *m_mutex;

};

#endif
