/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2025 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_ANNOTATION_
#define  _SO_ANNOTATION_

#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/SoType.h>

SO_PIMPL_PUBLIC_DECLARATION(SoAnnotation)

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoAnnotation
//
//  Annotation group node: delays rendering its children until all
//  other nodes have been traversed, turning off depth buffer
//  comparisons first. The result is that the shapes under the
//  annotation node are rendered on top of the rest of the scene.
//
//  Note that if more than one annotation node is present in a graph,
//  the order in which they are traversed determines the stacking
//  order - later nodes are rendered on top of earlier ones. Also note
//  that since depth buffer comparisons are disabled, complex 3D
//  objects may not be rendered correctly when used under annotation
//  nodes.
//
//  All non-rendering actions are inherited as is from SoSeparator.
//
//////////////////////////////////////////////////////////////////////////////
/**
 * Annotation group node.
 * 
 * @ingroup GroupNodes
 * 
 * @DESCRIPTION
 *   This group node delays rendering its children until all other nodes have been
 *   traversed, turning off depth buffer comparisons first. The result is that the
 *   shapes under the annotation node are rendered on top of the rest of the scene.
 *   This node is derived from SoSeparator, so it saves and restores traversal state
 *   for all actions.
 *   
 *   Rendering order: @BR
 *   Objects under an SoAnnotation node are rendered after "delayed" transparent
 *   objects.  See SoGLRenderAction for more information about rendering order.
 *   Note that if more than one annotation node is present in a graph, the order in
 *   which they are traversed determines the stacking order - later nodes are
 *   rendered on top of earlier ones.
 *
 *   Note: Because depth buffer comparisons are disabled, complex 3D objects may not
 *   be rendered correctly when used under annotation nodes. Moreover, camera's exposure
 *   fields do not impact the scene graph of this node, since its rendering is delayed
 *   after everything at the very end.
 *   
 *   Picking: @BR
 *   Also note that the annotation node does nothing special when picking along a ray.
 *   That is, it does not modify the sorting order of intersected objects based on
 *   which ones are under annotation nodes. If your application uses annotation nodes
 *   and you want to ensure that objects under them are picked "in front of" other
 *   objects, you can tell the pick action that you want to pick all objects along
 *   the ray and then scan through the paths in the resulting picked point instances
 *   to see if any of them passes through an annotation node. Your program can then
 *   decide what to do in such a case.
 * 
 * @FILE_FORMAT_DEFAULT
 *    Annotation {
 *    @TABLE_FILE_FORMAT
 *       @TR boundingBoxCaching   @TD AUTO
 *       @TR renderCulling        @TD AUTO
 *       @TR pickCulling          @TD AUTO
 *       @TR fastEditing          @TD FALSE
 *    @TABLE_END
 *    }
 * 
 * @ACTION_BEHAVIOR
 *    SoGLRenderAction @BR
 *        Delays rendering its children until all other nodes have been traversed,
 *        turning off depth buffer comparisons first.
 * 
 *    SoCallbackAction,  SoGetBoundingBoxAction,  SoGetMatrixAction,  SoRayPickAction,  SoSearchAction @BR
 *        Same as SoSeparator
 * 
 * 
 * 
 */
class INVENTOR_API SoAnnotation : public SoSeparator {

  SO_NODE_HEADER(SoAnnotation);
  SO_PIMPL_PUBLIC_HEADER(SoAnnotation)

 public:

  // No fields

  /**
   * Creates an annotation node with default settings.
   */
  SoAnnotation();

 SoEXTENDER public:
  // Implement actions
  virtual void        GLRender(SoGLRenderAction *action);
  virtual void        GLRenderBelowPath(SoGLRenderAction *action);
  virtual void        GLRenderInPath(SoGLRenderAction *action);
  virtual void        GLRenderOffPath(SoGLRenderAction *action);
  virtual int32_t     getRenderUnitID() const;

 SoINTERNAL public:
  static void         initClass();
  static void         exitClass();
  static void         setNoDelay(SbBool flag);
  static SbBool       getNoDelay();

 protected:
  // Destructor
  virtual ~SoAnnotation();

 private:
  void commonConstructor();
};

#endif /* _SO_ANNOTATION_ */

