/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef _SO_BACKGROUND_H_
#define _SO_BACKGROUND_H_

#include <Inventor/SbPImpl.h>
#include <Inventor/nodes/SoNode.h>

SO_PIMPL_PUBLIC_DECLARATION(SoBackground)

/**
 * Abstract base class for background nodes.
 * 
 * @ingroup BackgroundNodes
 * 
 * @DESCRIPTION
 *   This is the abstract base class for all background nodes.
 * 
 *  Note: Some background nodes can set Alpha values (as well as R, G and B
 *  values) in an RGBA framebuffer, but they cannot make Open Inventor's 
 *  rendering window transparent with respect to other windows on the desktop.
 *  This is a  window system specific feature and can only be handled through
 *  the window system API.
 * 
 * @SEE_ALSO
 *    SoGradientBackground,
 *    SoImageBackground
 */
class INVENTOR_API SoBackground : public SoNode {

  SO_PIMPL_PUBLIC_HEADER(SoBackground)
  SO_NODE_ABSTRACT_HEADER(SoBackground);

 public:

   // Fields:

 SoINTERNAL public:
   // Initializes this class for use in scene graphs. This
   // should be called after database initialization and before
   // any instance of this node is constructed.

   static void    initClass();
   static void    exitClass();

 SoEXTENDER public:
  // Overrides default method on SoNode
  virtual SbBool      affectsState() const;

 protected:
   // Constructor (abstract nodes cannot be created)
   SoBackground();
   
   // Destructor. Protected to keep people from trying to delete
   // nodes, rather than using the reference count mechanism.
   virtual ~SoBackground();

private:
  void commonConstructor();
};

#endif //SoBackground

