/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Ronen Barzel (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_BLINKER_
#define  _SO_BLINKER_

#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/fields/SoSFFloat.h>
#include <Inventor/fields/SoSFBool.h>
#include <Inventor/sensors/SoOneShotSensor.h>
#include <Inventor/engines/SoTimeCounter.h>
#include <Inventor/sensors/SoFieldSensor.h>


//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoBlinker
//
//  SoSwitch node cycles between all its children.
//  with only one child, cycles that child on and off.
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Animated cycling switch node.
 * 
 * @ingroup GroupNodes
 * 
 * @DESCRIPTION
 *   The SoBlinker class is derived from SoSwitch, so it selects one of its children
 *   to traverse. Using engines connected to the @B realTime @b global field, the
 *   @B whichChild @b field is animated over time. If the node has only one child,
 *   @B whichChild @b toggles between SO_SWITCH_NONE and 0, causing the child to be
 *   switched on and off repeatedly. If the node has more than one child, they are
 *   cycled through continuously.
 * 
 * @FILE_FORMAT_DEFAULT
 *    Blinker {
 *    @TABLE_FILE_FORMAT
 *       @TR whichChild   @TD -1
 *       @TR speed        @TD 1
 *       @TR on           @TD TRUE
 *    @TABLE_END
 *    }
 * 
 * @ACTION_BEHAVIOR
 *    SoGLRenderAction,  SoCallbackAction,  SoGetBoundingBoxAction,  SoGetMatrixAction,  SoHandleEventAction,  SoRayPickAction,  SoSearchAction @BR
 *        Same as for SoSwitch.
 * 
 * 
 * 
 */
class INVENTOR_API SoBlinker : public SoSwitch {

  SO_NODE_HEADER(SoBlinker);

 public:
  // Fields
  /**
   * Defines the speed of the blinker, in cycles per second.
   * 
   */
  SoSFFloat           speed;
  /**
   * Allows applications to enable or disable the blinking easily.
   * 
   */
  SoSFBool            on;

  /**
   * Creates a blinker node with default settings.
   */
  SoBlinker();

 SoEXTENDER public:
  // Bounding box computation takes all children into account
  virtual void        getBoundingBox(SoGetBoundingBoxAction *action);

  // overload write method not to write internal engines
  virtual void        write(SoWriteAction *action);

 SoINTERNAL public:
  static void         initClass();
  static void         exitClass();
  
  virtual void        notify(SoNotList *);

 protected:
  virtual ~SoBlinker();

 private:
  SbBool              wasOn;  // Remembers previous state of "on" field

  // keep track of internal connection
  class SoEngineOutput        *internalConnection;

  class SoTimeCounter *count;
  void                setupCounter();
  int                 nchildren;

  class SoOneShotSensor       *childrenSensor;
  class SoOneShotSensor       *whichChildSensor;
  class SoFieldSensor         *onSensor;

  static void childrenSensorCB(void *data, class SoSensor *sensor);
  static void whichChildSensorCB(void *data, class SoSensor *sensor);
  static void onSensorCB(void *data, class SoSensor *sensor);
};

#endif /* _SO_BLINKER_ */

