/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Dave Immel (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_INDEXED_NURBS_CURVE_
#define  _SO_INDEXED_NURBS_CURVE_

#include <Inventor/fields/SoSFInt32.h>
#include <Inventor/fields/SoMFFloat.h>
#include <Inventor/fields/SoMFInt32.h>
#include <Inventor/nodes/SoNurbsCurve.h>

SO_PIMPL_PUBLIC_DECLARATION(SoIndexedNurbsCurve)

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoIndexedNurbsCurve
//
//  NURBS curve using an indexed list for the control points.
//
//////////////////////////////////////////////////////////////////////////////

class SoState;
class SoIndexedNurbsCurveCache;
class SbThreadRWMutex;

/**
 * Indexed NURBS curve shape node.
 * 
 * @ingroup ShapeNodes
 * 
 * @DESCRIPTION
 *   This class represents a NURBS curve based on the knot vector and the control
 *   points that you specify. The #knotVector field specifies a floating-point
 *   array of values; the values are the coordinates of the knot points in the curve,
 *   and you must enter them in non-decreasing order. The #numControlPoints
 *   field specifies the number of control points the curve will have and will use
 *   the current coordinates that are indexed from the #coordIndex field.
 *   
 *   You can get a curve of minimum order (2) by specifying two more knots than
 *   control points and having at least two control points. This curve would be a set
 *   of line segments connecting the control points together.
 *   
 *   You can get a curve of maximum order (8) by specifying 8 more knots than control
 *   points and having at least 8 control points. In this curve, each control point
 *   would have influence on a larger portion of the curve than with curves of lesser
 *   order.
 *   
 *   The control points of the curve are transformed by the current transformation
 *   matrix. The curve is drawn with the current lighting model and drawing style
 *   (drawing style FILLED is treated as LINES). The coordinates, normals, and
 *   texture coordinates of a NURBS curve are generated, so you cannot bind explicit
 *   normals or texture coordinates to a NURBS curve.
 *   
 *   The approximation of the curve by line segments is affected by the current
 *   complexity value.
 *
 *   Shape Antialiasing type is SoShape::LINES.
 * 
 * @FILE_FORMAT_DEFAULT
 *    IndexedNurbsCurve {
 *    @TABLE_FILE_FORMAT
 *       @TR numControlPoints   @TD 0
 *       @TR coordIndex         @TD 0
 *       @TR knotVector         @TD 0
 *    @TABLE_END
 *    }
 * 
 * @ACTION_BEHAVIOR
 *    SoGLRenderAction @BR
 *        Draws the curve based on the current coordinates, material, and so on.
 * 
 *    SoRayPickAction @BR
 *        Picks the curve based on the current coordinates and transformation.
 * 
 *    SoGetBoundingBoxAction @BR
 *        Computes the bounding box that encloses all control points of the curve with
 *        the current transformation applied to them. Sets the center to the average of
 *        the control points.
 * 
 *    SoCallbackAction @BR
 *        If any line segment callbacks are registered with the action, they will be
 *        invoked for each successive segment approximating the curve.
 * 
 * 
 * @SEE_ALSO
 *    SoFullSceneAntialiasing,
 *    SoNurbsCurve,
 *    SoIndexedNurbsSurface
 * 
 * 
 */
class INVENTOR_API SoIndexedNurbsCurve : public SoNurbsCurve {
  
  SO_NODE_HEADER(SoIndexedNurbsCurve);
  SO_PIMPL_FINAL_PUBLIC_HEADER(SoIndexedNurbsCurve)
  
 public:
  /**
   * Coordinate indices for the control points.
   */
  SoMFInt32 coordIndex;

  /**
   * Creates an indexed NURBS curve node with default settings.
   */
  SoIndexedNurbsCurve();

 SoEXTENDER public:
  // Computes bounding box of curve
  virtual void computeBBox(SoAction *action, SbBox3f &box,
                           SbVec3f &center);
  
 SoINTERNAL public:
  static void initClass();
  static void exitClass();
  
 protected:
  ~SoIndexedNurbsCurve();

};

#endif /* _SO_INDEXED_NURBS_CURVE_ */

