/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Dave Immel (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_INDEXED_NURBS_SURFACE_
#define  _SO_INDEXED_NURBS_SURFACE_

#include <Inventor/fields/SoSFInt32.h>
#include <Inventor/fields/SoMFFloat.h>
#include <Inventor/fields/SoMFInt32.h>
#include <Inventor/nodes/SoNurbsSurface.h>

class SoState;
class SoIndexedNurbsSurfaceCache;
class SoNurbsBREPAction;
class SoBrep;
class Pquad_tess_param;
class GLUnurbs;
class SbThreadRWMutex;

SO_PIMPL_PUBLIC_DECLARATION(SoIndexedNurbsSurface)

/**
 * Indexed NURBS surface shape node.
 * 
 * @ingroup ShapeNodes
 * 
 * @DESCRIPTION
 *   This shape node represents a NURBS surface based on the knot vectors and the
 *   control points that you specify. The #uKnotVector and #vKnotVector
 *   fields specify floating-point arrays of values; the values are the coordinates
 *   of the knot points in the surface, and you must enter them in non-decreasing
 *   order. The #numUControlPoints and #numVControlPoints fields specify
 *   the number of control points the surface will have in the U and V parametric
 *   directions, and will use the current coordinates that are indexed from the
 *   #coordIndex field.
 *   
 *   You can get a surface of minimum order (2) in the U or V directions by specifying
 *   two more knots than control points in that direction and having at least two
 *   control points in that direction. This surface would appear creased in one
 *   direction.
 *   
 *   You can get a surface of maximum order (8) in the U or V directions by specifying
 *   eight more knots than control points in that direction and having at least eight
 *   control points in that direction.
 *   
 *   The control points of the NURBS surface are transformed by the current cumulative
 *   transformation. The surface is drawn with the current light model and drawing
 *   style. The coordinates, normals, and texture coordinates of a surface are
 *   generated, so you cannot bind explicit normals or texture coordinates to a NURBS
 *   surface. The first material in the state is applied to the entire surface.
 *   
 *   The surface is trimmed according to the currently defined profiles curves.
 *   
 *   When default texture coordinates are applied to a NURBS surface, the edges of the
 *   texture square are stretched to fit the surface. The axes of the texture are
 *   called S and T; S is horizontal and T is vertical. The axes of the NURBS surface
 *   are called U and V; U is horizontal and V is vertical. You can also define
 *   texture coordinates explicitly with the S,T location point, the knot vectors,
 *   and the current texture coordinates.
 *
 *   @B NOTE@b:
 *   - The fields #textureCoordIndex, #numSControlPoints, #numTControlPoints, #sKnotVector and #tKnotVector
 *     are not used.
 *
 * @FILE_FORMAT_DEFAULT
 *    IndexedNurbsSurface {
 *    @TABLE_FILE_FORMAT
 *       @TR numUControlPoints   @TD 0
 *       @TR numVControlPoints   @TD 0
 *       @TR numSControlPoints   @TD 0
 *       @TR numTControlPoints   @TD 0
 *       @TR coordIndex          @TD 0
 *       @TR uKnotVector         @TD 0
 *       @TR vKnotVector         @TD 0
 *       @TR sKnotVector         @TD 0
 *       @TR tKnotVector         @TD 0
 *       @TR textureCoordIndex   @TD -1
 *    @TABLE_END
 *    }
 * 
 * @ACTION_BEHAVIOR
 *    SoGLRenderAction @BR
 *        Draws the surface based on the current coordinates, material, and so on.
 * 
 *    SoRayPickAction @BR
 *        Picks the surface based on the current coordinates and transformation.
 * 
 *    SoGetBoundingBoxAction @BR
 *        Computes the bounding box that encloses all control points of the surface with
 *        the current transformation applied to them. Sets the center to the average of
 *        the control points.
 * 
 *    SoCallbackAction @BR
 *        If any triangle callbacks are registered with the action, they will be invoked
 *        for each successive triangle approximating the surface.
 * 
 * 
 * @SEE_ALSO
 *    SoFullSceneAntialiasing,
 *    SoIndexedNurbsCurve,
 *    SoNurbsSurface,
 *    SoProfile
 * 
 * 
 */
class INVENTOR_API SoIndexedNurbsSurface : public SoNurbsSurface {
  
  SO_NODE_HEADER(SoIndexedNurbsSurface);
  SO_PIMPL_FINAL_PUBLIC_HEADER(SoIndexedNurbsSurface)
  
 public:
  /**
   * Coordinate indices.
   */
  SoMFInt32 coordIndex;

  /**
   * Texture coordinate indices.
   * Not used.
   */
  SoMFInt32 textureCoordIndex;

  /**
   * Creates an indexed NURBS surface node with default settings.
   */
  SoIndexedNurbsSurface();

 SoEXTENDER public:
  virtual void GLRender(SoGLRenderAction *action);

  // Computes bounding box of surface
  virtual void computeBBox(SoAction *action, SbBox3f &box, SbVec3f &center);


 SoINTERNAL public:
  static void initClass();
  static void exitClass();

 protected:
  ~SoIndexedNurbsSurface();

 private:
  inventor::impl::SoIndexedNurbsSurfaceImpl* getImpl();
};

#endif /* _SO_INDEXED_NURBS_SURFACE_ */

