/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Alain Dumesny (MMM yyyy)
** Modified by : Paul Isaacs (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2021 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_LOCATE_HIGHLIGHT_
#define  _SO_LOCATE_HIGHLIGHT_

#include <Inventor/fields/SoSFColor.h>
#include <Inventor/fields/SoSFEnum.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/elements/SoDepthBufferElement.h>

class SoAction;
class SoHandleEventAction;
class SoGLRenderAction;
class SoFullPath;
class SoColorPacker;

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoLocateHighlight
//
//////////////////////////////////////////////////////////////////////////////

SO_PIMPL_PUBLIC_DECLARATION(SoLocateHighlight)

/**
 * @VSGEXT Special separator that performs locate highlighting.
 * 
 * @ingroup GroupNodes
 * 
 * @DESCRIPTION
 *   This is a subclass of SoSeparator that redraws itself in a different color when
 *   the cursor is over the contents of the separator.
 *   
 *   The redraw happens for that separator only and not the entire window (redraw
 *   along the handle event pick path) and in the front buffer, to efficiently track
 *   the mouse motion. The highlighted redraw overrides the emissive and/or diffuse
 *   color of the subgraph based on the field values in this node.
 *   
 *   NOTE: when using SoLightModel::BASE_COLOR (to turn lighting off) only the diffuse
 *   color will be used to render objects, so EMISSIVE_DIFFUSE must be used for this
 *   node to have any effect.
 *
 * @B Limitations: @b
 *  - When using a SceneExaminer, subgraph can remain highlighted after switching from selection mode to viewing mode.
 *  - When using an examiner viewer or a SceneExaminer, subgraph can remain unhighlighted when switching from viewing mode to selection mode until the mouse is moved.
 *  - The SceneOrbiter does not have such limitation.
 *   
 *   To override the default mode (off), set environment variable
 *   IV_ALLOW_LOCATE_HIGHLIGHT to 1. This will allow locate highlighting to happen by
 *   default.
 * 
 * @FILE_FORMAT_DEFAULT
 *    LocateHighlight {
 *    @TABLE_FILE_FORMAT
 *       @TR boundingBoxCaching   @TD AUTO
 *       @TR renderCulling        @TD AUTO
 *       @TR pickCulling          @TD AUTO
 *       @TR mode                 @TD OFF
 *       @TR style                @TD EMISSIVE
 *       @TR color                @TD 0.3 0.3 0.3
 *       @TR fastEditing          @TD DISABLE
 *    @TABLE_END
 *    }
 * 
 * @ACTION_BEHAVIOR
 *    SoHandleEventAction @BR
 *        Checks to see if the cursor moves onto or off of the contents of the separator,
 *        and redraws appropriately (if #mode is AUTO), otherwise traverses as a
 *        normal separator.
 * 
 *    SoGLRenderAction @BR
 *        Redraws either highlighted (if cursor is over the contents of the separator
 *        when #mode == AUTO or always if #mode == ON), otherwise traverses as
 *        a normal separator.
 * 
 * 
 * @SEE_ALSO
 *    SoSeparator,
 *    SoSelection,
 *    SoMaterial
 * 
 */
class INVENTOR_API SoLocateHighlight : public SoSeparator {

  SO_NODE_HEADER(SoLocateHighlight);
  SO_PIMPL_PUBLIC_HEADER(SoLocateHighlight)

 public:

   /** Possible values for draw style */
  enum Styles {
    /**
     *  Changes emissive color only (default) 
     */
    EMISSIVE,
    /**
     *  Changes emissive and diffuse colors 
     */
    EMISSIVE_DIFFUSE
  };

  /** Possible values for the mode */
  enum Modes {
    /**
     *  Highlight when mouse is over 
     */
    AUTO,
    /**
     *  Always highlight 
     */
    ON,
    /**
     *  Never highlight (default) 
     */
    OFF
  };

  // Fields
  /**
   * Highlighting color - default [.3, .3, .3]
   * 
   */
  SoSFColor   color;
  /**
   * Highlighting draw style.
   * @useenum{Styles}. Default EMISSIVE.
   */
  SoSFEnum    style;
  /**
   * Whether to highlight or not.
   * @useenum{Modes}. Default OFF.
   */
  SoSFEnum    mode;

  /**
   * Creates a LocateHighlight node with default settings.
   */
  SoLocateHighlight();

#if SoDEPRECATED_BEGIN( 10810 )
  /**
   * This will de-highlight the currently highlighted node if any.
   * this should be called when the cursor leaves a window or a mode
   * changes happen which would prevent a highlighted node from receiving
   * more mouse motion events. The GL render action used to render into
   * that window needs to be passed to correctly un-highlight.
   */
  SoDEPRECATED_METHOD(10810, "This method is useless because the current highlighting of the subgraph is automatically turned off when switching from picking to viewing mode in viewers such as examiner viewers. However if your are using a custom viewer, you must send an SoLocation2Event::EventSource::OTHER event when switching modes instead of calling turnOffCurrentHighlight.")
  static void turnOffCurrentHighlight(SoGLRenderAction *action);
#endif /** @DEPRECATED_END */

 SoEXTENDER public:
  /**
   * Override handleEvent to look for mouse motion, to do a
   * pick and highlight if mouse is over us. The GLRender methods
   * are redefined to draw highlighted if needed.
   */
  virtual void handleEvent( SoHandleEventAction *action );

  /** @copydoc SoSeparator::GLRenderBelowPath */
  virtual void GLRenderBelowPath(SoGLRenderAction *action);
  
  /** @copydoc SoSeparator::GLRenderInPath */
  virtual void GLRenderInPath(SoGLRenderAction *action);

 SoINTERNAL public:
  /** @copydoc SoSeparator::initClass */
  static void initClass();
  /** @copydoc SoSeparator::exitClass */
  static void exitClass();

private:
  void commonConstructor();
};


#endif /* _SO_LOCATE_HIGHLIGHT_ */

