/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David Beilloin (Aug 2013)
**=======================================================================*/


#ifndef  _SO_MULTIPLE_INSTANCE_BASE_
#define  _SO_MULTIPLE_INSTANCE_BASE_

#include <Inventor/nodes/SoGroup.h>

SO_PIMPL_PUBLIC_DECLARATION(SoMultipleInstanceBase);

/**
 * Abstract group node that traverses its children multiple times.
 * 
 * @ingroup GroupNodes
 * 
 * @DESCRIPTION
 *   This abstract group node traverses its children, in order, multiple times, applying
 *   different per-instance attributes each time.
 *   This allows the user to put multiple copies of the same data in different locations easily and
 *   efficiently.
 *   
 *   Traversing the <B>N</B>th child sets the current switch value to @B N @b, for
 *   use with inherited switch values (see SoSwitch).
 * 
 * @ACTION_BEHAVIOR
 *    SoGLRenderAction,  SoCallbackAction,  SoGetBoundingBoxAction,  SoRayPickAction @BR
 *        Traverses all children for each matrix, saving and restoring state before and
 *        after each traversal. Sets: SoSwitchElement
 * 
 *    SoSearchAction @BR
 *        Traverses all children once, setting the inherited switch value to
 *        SO_SWITCH_ALL first.
 * 
 * 
 * @SEE_ALSO
 *    SoMultipleInstance, SoMultipleCopy, SoArray, SoSwitch
 * 
 */
class INVENTOR_API SoMultipleInstanceBase : public SoGroup {

  SO_NODE_ABSTRACT_HEADER(SoMultipleInstanceBase);
  SO_PIMPL_PUBLIC_HEADER(SoMultipleInstanceBase);

 public:

 SoEXTENDER public:
  /** Returns FALSE as state is saved/restore like a SoSeparator on action traversal */
  virtual SbBool affectsState() const
  { return FALSE; }

  // Implement actions
  virtual void doAction(SoAction *action);

  /** Implements SoGLRenderAction traversal. */
  virtual void GLRender( SoGLRenderAction *action );

  /** Implements SoGetBoundingBoxAction traversal. */
  virtual void getBoundingBox( SoGetBoundingBoxAction *action );

  /** Implements SoGetPrimitiveCount traversal. */
  virtual void getPrimitiveCount( SoGetPrimitiveCountAction *action );

  /** Implements SoCallbackAction traversal. */
  virtual void callback( SoCallbackAction *action );

  /** Implements SoRayPickAction traversal. */
  virtual void rayPick(SoRayPickAction *action);

  /** Implements SoHandleEventAction traversal. */
  virtual void handleEvent(SoHandleEventAction *action);

  /** Implements SoGetMatrixAction traversal. */
  virtual void getMatrix(SoGetMatrixAction *action);

  /** Implements SoSearchAction traversal. */
  virtual void search(SoSearchAction *action);

 SoINTERNAL public:
  /** @copydoc SoNode::initClass() */
  static void initClass();

  /** @copydoc SoNode::exitClass() */
  static void exitClass();

 protected:
   /** Destructor */
  virtual ~SoMultipleInstanceBase();

 private:
  //private with no definition to avoid its generation by the compiler.
  SoMultipleInstanceBase();
};

#endif /* _SO_MULTIPLE_INSTANCE_BASE_ */
