
/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2019 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_NON_INDEXED_SHAPE_
#define  _SO_NON_INDEXED_SHAPE_

#include <Inventor/fields/SoSFInt32.h>
#include <Inventor/nodes/SoVertexShape.h>
#include <Inventor/SbPImpl.h>

SO_PIMPL_PUBLIC_DECLARATION(SoNonIndexedShape)

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoNonIndexedShape
//
//  Abstract nonindexed shape node class. All nodes derived from this
//  (such as SoFaceSet and SoTriangleStripSet) are shapes constructed
//  from vertices defined by consecutive entries in the current
//  coordinates. The startIndex field gives the index into the current
//  coordinates at which the shape begins.
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Abstract base class for all non-indexed vertex-based shapes.
 * 
 * @ingroup ShapeNodes
 * 
 * @DESCRIPTION
 *   This node is the abstract base class for all vertex-based shapes that are not
 *   constructed from indices, such as SoFaceSet, SoLineSet, and SoQuadMesh.
 *   
 *   All subclasses of SoNonIndexedShape construct objects by using the coordinates
 *   specified in the #vertexProperty field (from SoVertexShape), or the
 *   current inherited coordinates.
 *   
 *   The subclass decides what to do with this and any subsequent coordinates. The
 *   shape is drawn with the current lighting model and drawing style and is
 *   transformed by the current transformation matrix.
 *   
 *   Material, normal, tangent, and texture coordinate bindings for shapes derived from this
 *   class ignore any index specifications. That is, a binding value of
 *   PER_FACE_INDEXED is treated the same way as PER_FACE, and so on.
 *   
 *   If there aren't sufficient values in the current coordinates, material, or
 *   texture coordinates, errors will occur.
 * 
 * @FILE_FORMAT_DEFAULT
 *    This is an abstract class. See the reference page of a derived class for the
 *   format and default values.
 * 
 * @SEE_ALSO
 *    SoFaceSet,
 *    SoIndexedShape,
 *    SoLineSet,
 *    SoPointSet,
 *    SoQuadMesh,
 *    SoTriangleStripSet,
 *    SoVertexProperty
 * 
 * 
 */
class INVENTOR_API SoNonIndexedShape : public SoVertexShape
{
  SO_NODE_ABSTRACT_HEADER(SoNonIndexedShape);
  SO_PIMPL_PUBLIC_HEADER(SoNonIndexedShape)

public:

  /**
   * Index of first coordinate of shape.
   */
  SoSFInt32 startIndex;

SoINTERNAL public:

  static void initClass();
  static void exitClass();

  // Redefines this to invalidate normal and tangent caches
  virtual void notify( SoNotList* list );

SoEXTENDER public:
  /**
   * This handles AABB bounding box computation for all shapes derived
   * from this class. It sets the bounding box to contain all
   * vertices of the shape, assuming that the shape uses the
   * coordinates indexed by all non-negative values in the
   * coordIndex field. It also sets the center to the average of the
   * vertices' coordinates.
   */
  virtual void computeBBox( SoAction* action, SbBox3f& box, SbVec3f& center );

  /**
   * This handles OOBB bounding box computation for all shapes derived
   * from this class. It sets the bounding box to contain all
   * vertices of the shape, assuming that the shape uses the
   * coordinates indexed by all non-negative values in the
   * coordIndex field. It also sets the center to the average of the
   * vertices' coordinates.
   */
  virtual void computeBBox( SoAction* action, SbXfBox3d& box, SbVec3d& center );

protected:

  SoNonIndexedShape();
  virtual ~SoNonIndexedShape();

private:

  void commonConstructor();

};

#endif /* _SO_NON_INDEXED_SHAPE_ */

