/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Dave Immel (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_NURBS_SURFACE_
#define  _SO_NURBS_SURFACE_

#include <Inventor/fields/SoMFFloat.h>
#include <Inventor/fields/SoSFInt32.h>
#include <Inventor/nodes/SoShape.h>

class SoState;
class SoChildList;

SO_PIMPL_PUBLIC_DECLARATION(SoNurbsSurface)

/**
 * NURBS surface shape node.
 * 
 * @ingroup ShapeNodes
 * 
 * @DESCRIPTION
 *   This shape node represents a NURBS surface based on the node's knot vectors and
 *   on control points constructed from the current coordinates. The current
 *   coordinates are used in row-major order (the V direction corresponds to the
 *   rows). The number of coordinates used is determined by the
 *   #numUControlPoints and #numVControlPoints fields. The
 *   #uKnotVector and #vKnotVector fields contain floating point arrays
 *   of non-decreasing values.
 *   
 *   The order of the surface in the U and V directions is defined as the number of
 *   knots minus the number of control points in the particular direction. The
 *   largest order allowed for a NURBS surface is 8.
 *   
 *   The control points of the NURBS surface are transformed by the current cumulative
 *   transformation. The surface is drawn with the current light model and drawing
 *   style. The coordinates, normals, and texture coordinates of a surface are
 *   generated, so you cannot bind explicit normals or texture coordinates to a NURBS
 *   surface. The first material in the state is applied to the entire surface.
 *   
 *   The surface is trimmed according to the currently defined profile's curves.
 *   
 *   When default texture coordinates are applied to a NURBS surface, the edges of the
 *   texture square are stretched to fit the surface. The axes of the texture are
 *   called S and T; S is horizontal and T is vertical. The axes of the NURBS surface
 *   are called U and V; U is horizontal and V is vertical. You can also define
 *   texture coordinates explicitly with the S,T location point, the knot vectors,
 *   and the current texture coordinates. The number of texture coordinates used is 
 *   determined by the #numSControlPoints and #numTControlPoints fields. 
 *   
 *   The approximation of the surface by polygons is affected by the current
 *   complexity value.
 *
 *   @B NOTE@b:
 *   - The fields #numSControlPoints, #numTControlPoints, #sKnotVector and #tKnotVector
 *     are not used.
 * 
 * @FILE_FORMAT_DEFAULT
 *    NurbsSurface {
 *    @TABLE_FILE_FORMAT
 *       @TR numUControlPoints   @TD 0
 *       @TR numVControlPoints   @TD 0
 *       @TR numSControlPoints   @TD 0
 *       @TR numTControlPoints   @TD 0
 *       @TR uKnotVector         @TD 0
 *       @TR vKnotVector         @TD 0
 *       @TR sKnotVector         @TD 0
 *       @TR tKnotVector         @TD 0
 *    @TABLE_END
 *    }
 * 
 * @ACTION_BEHAVIOR
 *    SoGLRenderAction @BR
 *        Draws the surface based on the current coordinates, material, and so on.
 * 
 *    SoRayPickAction @BR
 *        Picks the surface based on the current coordinates and transformation.
 * 
 *    SoGetBoundingBoxAction @BR
 *        Computes the bounding box that encloses all control points of the surface with
 *        the current transformation applied to them. Sets the center to the average of
 *        the control points.
 * 
 *    SoCallbackAction @BR
 *        If any triangle callbacks are registered with the action, they will be invoked
 *        for each successive triangle approximating the surface.
 * 
 * 
 * @SEE_ALSO
 *    SoIndexedNurbsSurface,
 *    SoNurbsCurve,
 *    SoNurbsProperty,
 *    SoProfile
 * 
 * 
 */
class INVENTOR_API SoNurbsSurface : public SoShape {

  SO_NODE_HEADER(SoNurbsSurface);
  SO_PIMPL_PUBLIC_HEADER(SoNurbsSurface)
  
 public:
  /**
   * Number of control points in the U direction.
   * Default is 0.
   */
  SoSFInt32 numUControlPoints;

  /**
   * Number of control points in the V direction.
   * Default is 0.
   */
  SoSFInt32 numVControlPoints;

  /**
   * Number of control points in the S direction.
   * Default is 0. Not used.
   */
  SoSFInt32 numSControlPoints;

  /**
   * Number of control points in the T direction.
   * Default is 0. Not used.
   */
  SoSFInt32 numTControlPoints;

  /**
   * The knot vectors in the U direction.
   * Default is 0.
   */
  SoMFFloat uKnotVector;

  /**
   * The knot vectors in the V direction.
   * Default is 0.
   */
  SoMFFloat vKnotVector;

  /**
   * The knot vectors in the S direction.
   * Default is 0. Not used.
   */
  SoMFFloat sKnotVector;

  /**
   * The knot vectors in the T direction.
   * Default is 0. Not used.
   */
  SoMFFloat tKnotVector;

  /**
   * Creates a NURBS surface node with default settings.
   */
  SoNurbsSurface();

 SoEXTENDER public:
  virtual void GLRender(SoGLRenderAction *action);
  virtual void rayPick(SoRayPickAction *action);
  virtual void getPrimitiveCount(SoGetPrimitiveCountAction *action);
  virtual void getBoundingBox(SoGetBoundingBoxAction *action);

  // Computes bounding box of surface
  virtual void computeBBox(SoAction *action, SbBox3f &box, SbVec3f &center);

 SoINTERNAL public:
  static void initClass();
  static void exitClass();

 protected:
  // Generates triangles representing a surface
  virtual void generatePrimitives(SoAction *action);
  virtual SoChildList *getChildren() const;

  ~SoNurbsSurface();

private:
  void commonConstructor();
  inventor::impl::SoNurbsSurfaceImpl* getImpl();

  SoChildList* m_children;

  friend class SoNurbsBREPAction;
  friend class SoNurbsGroup;

};

#endif /* _SO_NURBS_SURFACE_ */

