/*=======================================================================
*** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
***                                                                                ***
***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
***                                                                                ***
***                        RESTRICTED RIGHTS LEGEND                                ***
***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
***                                                                                ***
***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
***                        BORDEAUX, FRANCE                                        ***
***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/

#pragma once

#include <Inventor/nodes/SoGroup.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoTexture2.h>
#include <Inventor/nodes/SoCallback.h>
#include <Inventor/nodes/SoShaderProgram.h>
#include <Inventor/nodes/SoSwitch.h>

class SoRayPickAction;

/**
  Group node dedicated to render multiple co-planar shapes.

  @ingroup GroupNodes

  @DESCRIPTION
  Derived from the class SoGroup, the SoOverlayGroup node renders
  multiple co-planar shapes without any Z-fighting artifacts.

  Overlapping co-planar shapes should be inserted as children of a SoOverlayGroup.
  The shapes are stacked for the rendering according to their places in the child list:
  the i th shape will be drawn above the i-1 th shape.

  For instance, in the following picture the red square is the first shape child,
  and the green triangle is the second shape child of a SoOverlayGroup.
    @IMAGE SoOverlay_redgreen.png width=700
  In the following picture, the green triangle is the first shape child.
    @IMAGE SoOverlay_greenred.png width=700
  In this picture, the square and the triangle are inserted in a SoGroup, which
  does not prevent the Z-fighting artifact where the 2 shapes overlap.
    @IMAGE SoOverlayGroup_nooverlay.png width=700

  The SoOverlayGroup is only designed to correctly render planar shapes.
  Inserting in SoOverlayGroup spheres, cylinders, cubes or any shape whose
  vertices are not on a single euclidean plane may cause an unexpected rendering.
  However, this does not limit the SoOverlayGroup to 2D rendering.
  You can create several SoOverlayGroup instances, but all the shapes under an overlay group
  must be a planar shape and must be located on the same 3D plane.
  One different 3D plane per instance of SoOverlayGroup is possible as in the
  following picture from the example "Inventor\Features\OverlayPanels" in which
  each panel corresponds to one instance of an SoOverlayGroup.
    @IMAGE OverlayPanels.png

  The SoOverlayGroup is not designed to solve any Z-fighting artifact on
  3D shapes. For instance, a correct rendering of meridian circles onto a sphere
  requires using either SoPolygonOffset or SoDepthOffset.

  # Limitations of the overlay group:
   - The SoHaloHighlightRenderAction can be used to highlight any shape
     in a SoOverlayGroup, but the alwaysVisible option must be TRUE.
     See SoHaloHighlightRenderAction::setHaloAlwaysVisible().
   - The behaviour of a SoColorHighlightRenderAction with an SoOverlayGroup
     is the same as with an SoGroup, thus some Z-fighting may occur.

  @FILE_FORMAT_DEFAULT
    OverlayGroup {
    @TABLE_FILE_FORMAT
    @TABLE_END
    }

  @ACTION_BEHAVIOR
    Similar behavior as described in SoGroup.

  @SEE_ALSO
    SoDepthOffset,
    SoGroup,
    SoPolygonOffset,
    SoSeparator,
    SoSwitch

  @NODE_SINCE_OIV 2024.1
*/
class INVENTOR_API SoOverlayGroup : public SoGroup
{
  SO_NODE_HEADER(SoOverlayGroup);

public:
  /**
   * Creates an empty overlay group node.
   */
  SoOverlayGroup();

SoEXTENDER public:
  void GLRender(SoGLRenderAction* action) override;
  void rayPick(SoRayPickAction* action) override;

SoINTERNAL public:

  // Specifies whether SoOverlayGroup behavior is enabled or disabled.
  // If disabled, the SoOverlayGroup behaves like an SoGroup.
  // Default is true.
  SoSFBool enabled;

  static void initClass();
  static void exitClass();

protected:
  ~SoOverlayGroup() override;

private:
  SoRef<SoSeparator> m_composeOpaque;
  SoRef<SoSeparator> m_composeTransp;

  std::vector<SoCallback*> m_callbackNodes;
  SoRef<SoCallback> m_updateElementsCallback;

  SoRef<SoTexture2> m_depthTexture;
  SoRef<SoTexture2> m_colorTexture;

  SoRef<SoShaderProgram> m_opaqueShaderProg;
  SoRef<SoShaderProgram> m_transparentShaderProg;
};
