/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
** Modified by : Nick Thompson (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_PATH_SWITCH_
#define  _SO_PATH_SWITCH_

#include <Inventor/fields/SoSFPath.h>
#include <Inventor/nodes/SoGroup.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoPathSwitch
//
//  PathSwitch group node: traverses all children only if the path
//  traversed so far matches the one stored in the "path" field. A
//  successful match means that the N nodes in the stored path chain
//  are the same as the last N nodes in the current path, not
//  including the path switch node itself. A NULL path (the default)
//  means don't traverse the children.
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Group node that traverses only when traversed along a given path.
 * 
 * @ingroup GroupNodes
 * 
 * @DESCRIPTION
 *   SoPathSwitch is a group node that traverses its children only if the current
 *   traversal path matches the SoPath in the #path field. 
 *
 *   This can be used,
 *   for example, to affect only one instance of a subgraph. The #path field
 *   contains the path up to (but not including) the SoPathSwitch. The path need not
 *   go all the way back to the root; if it does not, then only the number of
 *   ancestors that are in the path are compared to see if the children should be
 *   traversed.
 *
 *   An empty path (the default) means that no children are traversed.
 *
 *   There is an extended version of this node, SoMultiPathSwitch, that traverses
 *   its children if the current path matches any of the paths in a list of paths.
 *
 *   @B Note@b: This node disables the bounding box cache for all SoSeparator nodes above
 *   it in the scene graph. This may reduce performance when moving the camera and the 
 *   viewer's auto clip plane adjustment is enabled (the default). (It does not affect render caching.)
 * 
 * @FILE_FORMAT_DEFAULT
 *    PathSwitch {
 *    @TABLE_FILE_FORMAT
 *       @TR path   @TD NULL
 *    @TABLE_END
 *    }
 * 
 * @ACTION_BEHAVIOR
 *    SoGetBoundingBoxAction @BR
 *        Traverses the children if the paths match. Disables bounding box caches.
 *
 *    SoGLRenderAction,  SoCallbackAction,  SoGetBoundingBoxAction,  SoRayPickAction,  SoHandleEventAction @BR
 *        Traverses the children if the paths match.
 * 
 * 
 * @SEE_ALSO
 *    SoPath,
 *    SoMultiPathSwitch,
 *    SoMultiSwitch,
 *    SoSwitch
 * 
 */
class INVENTOR_API SoPathSwitch : public SoGroup {

  SO_NODE_HEADER(SoPathSwitch);

 public:
  // Fields
  /**
   * The path that must match the current traversal path.
   * Default is empty.
   */
  SoSFPath            path;

  /**
   * Creates a path switch node with default settings.
   */
  SoPathSwitch();

  /**
   * Constructor that takes approximate number of children.
   */
  SoPathSwitch(int nChildren);

 SoEXTENDER public:
  // Implement actions
  virtual void        doAction(SoAction *action);
  virtual void        GLRender(SoGLRenderAction *action);
  virtual void        pick(SoPickAction *action);
  virtual void        getBoundingBox(SoGetBoundingBoxAction *action);
  virtual void        handleEvent(SoHandleEventAction *action);
  virtual void        getMatrix(SoGetMatrixAction *action);
  virtual void        search(SoSearchAction *action);
  virtual void        getPrimitiveCount(SoGetPrimitiveCountAction *action);

 SoINTERNAL public:
  static void         initClass();
  static void         exitClass();

 protected:
  virtual ~SoPathSwitch();

 private:

  // Checks for match of path with current path
  SbBool              matchesPath(const SoPath *switchPath,
                                  const SoPath *currentPath) const;
};

#endif /* _SO_PATH_SWITCH_ */

