/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/

#pragma once

#include <Inventor/nodes/SoNode.h>
#include <Inventor/SbPImpl.h>
#include <Inventor/misc/SoRef.h>
#include <Inventor/fields/SoSFInt32.h>
#include <Inventor/fields/SoSFBufferObject.h>
#include <Inventor/fields/SoSFEnum.h>
#include <Inventor/SbEnums.h>
#include <Inventor/nodes/SoShaderParameter.h>

SO_PIMPL_BASE_PUBLIC_DECLARATION(SoShaderParameterBufferObject);

/**
 * @VSGEXT Shader parameter node storing a buffer object.
 *
 * @ingroup ShaderNodes
 *
 * @DESCRIPTION
 *   This node allows the application to provide a buffer object to a shader program.
 *   The shader program can access this buffer as a GLSL Shader Storage Buffer Object.
 *
 *   SoShaderParameterBufferObject nodes are usually added to the shader program's @I bufferObjects@i
 *   field to affect only that specific shader program, but can also be inserted in the scene
 *   graph and affect all subsequent shader programs.
 *
 *   NOTE: If inserted directly in the scene graph, SoShaderParameterBufferObject is @B not cacheable.@b
 *   This means that all parent SoSeparator nodes will not be able to create render caches.
 *   This may reduce rendering performance.
 *
 * @FILE_FORMAT_DEFAULT
 *    SoShaderParameterBufferObject {
 *      @TABLE_FILE_FORMAT
 *        @TR buffer            @TD NULL
 *        @TR bufferType        @TD SHADER_STORAGE_BUFFER
 *      @TABLE_END
 *    }
 *
 *
 * @SEE_ALSO
 *    SoShaderParameter, SoUniformShaderParameter.
 *    SoShaderObject, SoShaderProgram.
 *
 * @NODE_SINCE_OIV 9.8
 */
class INVENTOR_API SoShaderParameterBufferObject : public SoShaderParameter
{
  SO_PIMPL_BASE_PUBLIC_HEADER(SoShaderParameterBufferObject);
  SO_NODE_HEADER(SoShaderParameterBufferObject);
  RENDERER_RESOURCE(SoShaderParameterBufferObject);

  public:

   /**
    * List of buffer object types supported as shader parameter.
    */
    enum BufferType {
      SHADER_STORAGE_BUFFER = SbEnums::SHADER_STORAGE_BUFFER,
      UNIFORM_BUFFER = SbEnums::UNIFORM_BUFFER
    };

    SoShaderParameterBufferObject();

    /** An SoBufferObject containing data. In order to avoid a CPU to GPU copy,
     *  it is recommended to use an SoGpuBufferObject. Default is null. */
    SoSFBufferObject buffer;

    /** The buffer type. Default is SHADER_STORAGE_BUFFER.
     *  The only legal values are SHADER_STORAGE_BUFFER and UNIFORM_BUFFER. */
    SoSFEnum bufferType;

  SoEXTENDER public:
    void GLRender(SoGLRenderAction* action);

  SoINTERNAL public:
    static void initClass() ;
    static void exitClass() ;

    void fieldHasChanged(SoField* field) override;

  protected:
    virtual ~SoShaderParameterBufferObject();
};

