/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
** Modified by : Nick Thompson (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2021 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_SPHERE_
#define  _SO_SPHERE_

#include <Inventor/SbVec.h>
#include <Inventor/SbBox.h>
#include <Inventor/fields/SoSFFloat.h>
#include <Inventor/nodes/SoShape.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoSphere
//
//  Simple sphere. By default a sphere has radius 1 and is centered
//  around the origin.
//
//////////////////////////////////////////////////////////////////////////////

SO_PIMPL_PUBLIC_DECLARATION( SoSphere );

/**
 * Sphere shape node.
 * 
 * @ingroup ShapeNodes
 * 
 * @DESCRIPTION
 *   This node represents a sphere. By default, the sphere is centered at the origin
 *   and has a radius of 1. The sphere is transformed by the current cumulative
 *   transformation and is drawn with the current lighting model, drawing style,
 *   material, and geometric complexity.
 *
 *   A sphere does not have faces or parts. Therefore, the sphere ignores material and
 *   normal bindings, using the first material for the entire sphere and using its
 *   own normals. When a texture is applied to a sphere, the texture covers the
 *   entire surface, wrapping counterclockwise from the back of the sphere. The
 *   texture has a seam at the back on the yz-plane.
 *
 *   Picking: There is no SoDetail class associated with this node.
 *
 *   OpenGL vertex arrays are used if they are available and if the
 *   environment variable IV_NO_VERTEX_ARRAY is not set.
 *
 *   Consider using the SoAlgebraicSphere node instead of this one.  Algebraic shapes
 *   are computed and rendered on the GPU and can be used with SoMultipleInstance.
 * 
 * @FILE_FORMAT_DEFAULT
 *    Sphere {
 *    @TABLE_FILE_FORMAT
 *       @TR radius   @TD 1
 *    @TABLE_END
 *    }
 * 
 * @ACTION_BEHAVIOR
 *    SoGLRenderAction @BR
 *        Draws sphere based on the current coordinates, materials, drawing style, and so
 *        on.
 * 
 *    SoRayPickAction @BR
 *        Intersects the ray with the sphere. No details are created for intersections.
 * 
 *    SoGetBoundingBoxAction @BR
 *        Computes the bounding box that encloses the sphere.
 * 
 *    SoCallbackAction @BR
 *        If any triangle callbacks are registered with the action, they will be invoked
 *        for each successive triangle that approximates the sphere.
 * 
 * 
 * @SEE_ALSO
 *    SoAlgebraicSphere,
 *    SoCone,
 *    SoCube,
 *    SoCylinder,
 *    SoFullSceneAntialiasing
 * 
 * 
 */
class INVENTOR_API SoSphere : public SoShape
{

  SO_NODE_HEADER(SoSphere);
  SO_PIMPL_PUBLIC_HEADER( SoSphere );

public:
  // Fields
  /**
   * Radius of sphere. This must be greater than 0.
   * 
   */
  SoSFFloat           radius;

  /**
   * Creates a sphere node with default settings.
   */
  SoSphere();

 SoEXTENDER public:
  virtual void        GLRender(SoGLRenderAction *action);
  virtual void        rayPick(SoRayPickAction *action);
  virtual void        getPrimitiveCount(SoGetPrimitiveCountAction *action);

  // Computes bounding box of sphere
  virtual void        computeBBox(SoAction *action, SbBox3f &box,
                                  SbVec3f &center);

 SoINTERNAL public:
  static void         initClass();
  static void         exitClass();

  virtual SoChildList* getChildren() const;

 protected:
  // Generates triangles representing a sphere
  virtual void        generatePrimitives(SoAction *action);

  virtual ~SoSphere();
};

#endif /* _SO_SPHERE_ */
