/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : John Rohlf (MMM yyyy)
** Modified by : Thad Beier (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_TEXTURE_COORDINATE_2_
#define  _SO_TEXTURE_COORDINATE_2_

#include <Inventor/nodes/SoNode.h>
#include <Inventor/fields/SoMFVec2f.h>
#include <Inventor/fields/SoSFBool.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoTextureCoordinate2
//
//  TextureCoordinate2 point node.
//
//////////////////////////////////////////////////////////////////////////////

/**
 * 2D texture coordinate node.
 * 
 * @ingroup TextureNodes
 * 
 * @DESCRIPTION
 *   This node defines a set of 2D coordinates to be used to map textures
 *   to subsequent vertex-based shapes 
 *   (those derived from SoVertexShape). If you are using multiple textures,
 *   these texture coordinates apply to the current texture unit
 *   (SoTextureUnit).
 *   This node replaces
 *   the current texture coordinates in the rendering state for the shapes to use.
 *   
 *   The current texture coordinate binding (see SoTextureCoordinateBinding)
 *   determines how texture coordinates are mapped to vertices of shapes. An
 *   alternative to using explicit texture coordinates is to generate them using a
 *   function; see SoTextureCoordinateFunction.
 *   
 *   Texture coordinates range from 0 to 1 across the texture. The horizontal
 *   coordinate, called S, is specified first, followed by the vertical coordinate,
 *   T.
 * 
 * @FILE_FORMAT_DEFAULT
 *    TextureCoordinate2 {
 *    @TABLE_FILE_FORMAT
 *       @TR point          @TD [ ]
 *       @TR forceSending   @TD FALSE
 *    @TABLE_END
 *    }
 * 
 * @ACTION_BEHAVIOR
 *    SoGLRenderAction,  SoCallbackAction @BR
 *        Sets the current texture coordinates in the state.
 *        Sets: SoTextureCoordinateElement
 * 
 * @SEE_ALSO
 *    SoTexture2,
 *    SoTextureCoordinateBinding,
 *    SoTextureCoordinateFunction,
 *    SoTextureUnit,
 *    SoVertexProperty,
 *    SoVertexShape
 * 
 * 
 */
class INVENTOR_API SoTextureCoordinate2 : public SoNode {

  SO_NODE_HEADER(SoTextureCoordinate2);

 public:
  // Fields
  /**
   * Texture coordinate points.
   * 
   */
  SoMFVec2f           point;

  /**
   * Forces the texture coordinates to be sent to OpenGL
   * even if no texture is bound. Default is FALSE.
   * The default value can be set using the environment variable OIV_FORCE_TEX_COORD_SENDING.
   * See SoPreferences.
   *
   * @FIELD_SINCE_OIV 5.0.3
   */
  SoSFBool            forceSending; 
  
  /**
   * Creates a texture coordinate node with default settings.
   */
  SoTextureCoordinate2();

 SoEXTENDER public:
  virtual void        doAction(SoAction *action);
  virtual void        callback(SoCallbackAction *action);
  virtual void        GLRender(SoGLRenderAction *action);
  virtual void        pick(SoPickAction *action);

 SoINTERNAL public:
  static void         initClass();
  static void         exitClass();

 protected:
  virtual ~SoTextureCoordinate2();
};

#endif /* _SO_TEXTURE_COORDINATE_2_ */

