/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Patrick Vigneras (Nov 1999)
**=======================================================================*/

#ifndef  _SO_TEXTURE_COORDINATE_3_
#define  _SO_TEXTURE_COORDINATE_3_

#include <Inventor/nodes/SoNode.h>
#include <Inventor/fields/SoMFVec3f.h>
#include <Inventor/fields/SoSFBool.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoTextureCoordinate3
//
//  TextureCoordinate3 point node.
//
//////////////////////////////////////////////////////////////////////////////

/**
 * @VSGEXT 3D texture coordinate node.
 * 
 * @ingroup TextureNodes
 * 
 * @DESCRIPTION
 *   This node defines a set of 3D coordinates to be used to map textures to
 *   subsequent vertex-based shapes (those derived from SoVertexShape). It replaces
 *   the current texture coordinates in the rendering state for the shapes to use.
 *   
 *   The current texture coordinate binding (see SoTextureCoordinateBinding)
 *   determines how texture coordinates are mapped to vertices of shapes. An
 *   alternative to using explicit texture coordinates is to generate them using a
 *   function; see SoTextureCoordinateFunction.
 *   
 *   Texture coordinates range from 0 to 1 across the texture. The horizontal
 *   coordinate, called S, is specified first, then the vertical coordinate, T, and
 *   finally the depth coordinate, R.
 * 
 * @FILE_FORMAT_DEFAULT
 *    TextureCoordinate3 {
 *    @TABLE_FILE_FORMAT
 *       @TR point   @TD [ ]
 *       @TR forceSending   @TD FALSE
 *    @TABLE_END
 *    }
 * 
 * @ACTION_BEHAVIOR
 *    SoGLRenderAction,  SoCallbackAction @BR
 *        Sets the current texture coordinates in the state.
 *        Sets: SoTextureCoordinate3Element
 * 
 * @SEE_ALSO
 *    SoTexture3,
 *    SoTextureCoordinateBinding,
 *    SoTextureCoordinateFunction,
 *    SoVertexProperty,
 *    SoVertexShape
 * 
 * 
 */
class INVENTOR_API SoTextureCoordinate3 : public SoNode {

  SO_NODE_HEADER(SoTextureCoordinate3);

public:
  // Fields
  /**
   * Texture coordinate points.
   * 
   */
  SoMFVec3f           point;

  /**
   * Forces the texture coordinates to be sent to OpenGL
   * even if no texture is bound. Default is FALSE.
   * The default value can be set using the environment variable OIV_FORCE_TEX_COORD_SENDING.
   * See SoPreferences.
   *
   * @FIELD_SINCE_OIV 5.0.3
   */
  SoSFBool            forceSending; 
  
  /**
   * Creates a texture coordinate node with default settings.
   */
  SoTextureCoordinate3();

 SoEXTENDER public:
  virtual void        doAction(SoAction *action);
  virtual void        callback(SoCallbackAction *action);
  virtual void        GLRender(SoGLRenderAction *action);
  virtual void        pick(SoPickAction *action);

 SoINTERNAL public:
  static void         initClass();
  static void         exitClass();

protected:
  virtual ~SoTextureCoordinate3();
};

#endif /* _SO_TEXTURE_COORDINATE_3_ */

