/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

                                                             /* include files */
#ifndef _SO_VERTEX_SHADER_H_
#define _SO_VERTEX_SHADER_H_

#include <Inventor/nodes/SoShaderObject.h>

/*----------------------------------------------------------------------------*/

/**
 *
 * @VSGEXT Node that defines a vertex shader.
 * 
 * @ingroup ShaderNodes
 * 
 * @DESCRIPTION
 *   This node defines a vertex shader. 
 *
 *   See SoShaderProgram for general information about using shaders and shader parameters.
 *
 *   See parent class SoShaderObject for details about using the inherited fields.
 *
 * @B Notes:@b 
 *   - Shader object nodes cannot be inserted directly in a scene graph. \n
 *     They must be added to the @I shaderObject @i field of an SoShaderProgram node. 
 *
 *   - Predefined GLSL variables. @BR
 *     Open Inventor uses a compatibility profile context for rendering.  So legacy GLSL
 *     predefined variables, for example gl_ModelViewMatrix, can be used in vertex shaders.
 *     However, if you use the GLSL "#version" directive in a shader, you should append the
 *     keyword "compatibility", for example: "#version 150 compatibility".
 *
 *   - Shadows. @BR
 *     To integrate with Open Inventor's shadow casting algorithm, vertex shaders should
 *     call the GLSL method OivSetupShadowVertex(). Please see SoShadowGroup for example code.
 *
 * @B Limitations:@b
 *   - Transparency and fast editing are compatible with shader modified geometry, but most
 *     actions use the vertices of the basic shape (the vertices stored in the scene graph).
 *     This includes, for example, SoGetBoundingBoxAction, SoGetPrimitiveCountAction and SoRayPickAction.
 *
 * @FILE_FORMAT_DEFAULT
 *    VertexShader {
 *      @TABLE_FILE_FORMAT
 *        @TR sourceProgram    @TD ""
 *        @TR sourceType       @TD FILENAME
 *        @TR isActive         @TD TRUE
 *        @TR parameter        @TD NULL
 *      @TABLE_END
 *    }
 * 
 * @SEE_ALSO
 *    SoFragmentShader, 
 *    SoGeometryShader, 
 *    SoShaderObject, 
 *    SoShaderProgram,
 *    SoTessellationControlShader, 
 *    SoTessellationEvaluationShader, 
 *    SoUniformShaderParameter,
 *    SoVertexShaderParameter
 *
 * 
 */
class INVENTOR_API SoVertexShader : public SoShaderObject
{
  SO_NODE_HEADER(SoVertexShader);

public:
  /**
   * Constructor.
   */
  SoVertexShader();

  /**
   * Indicates if vertex shaders in the specified language are supported by 
   * your graphics board.
   * When using a debug build of Open Inventor, some "no context available"
   * warning messages may be generated. You can ignore them or see
   * SoGLExtension for an example of using SoGLContext to avoid them.
   */
  static SbBool isSupported(SoShaderObject::SourceType sourceType, SoState* state=NULL) ;

  /** Returns the shader type */
  virtual ShaderType getShaderType() const
  { return VERTEX_SHADER; }

SoINTERNAL public:

  /** register class in database */
  static void initClass();

  /** unregister class in database */
  static void exitClass();

protected:
  /** Destructor. */
  virtual ~SoVertexShader();
};

#endif
