/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David Beilloin (May 2011)
**=======================================================================*/
#ifndef _SO_VIEWPORT_H_
#define _SO_VIEWPORT_H_

#include <Inventor/nodes/SoNode.h>
#include <Inventor/elements/SoViewportRegionElement.h>

#include <Inventor/fields/SoSFVec2f.h>


class SoGLRenderAction;
class SoCallbackAction;
class SoPickAction;
class SoGetBoundingBoxAction;
class SoGetMatrixAction;
class SoHandleEventAction;


//@TOBEWRAPPED
/**
 * @VSGEXT Viewport parameters node.
 *
 * @ingroup PropertyNodes
 *
 * @DESCRIPTION
 *   This node specifies the viewport used for rendering.
 *
 *   The view volume specified by the current camera will be mapped
 *   into this region of the render target (e.g. the viewer window).
 *   By default Open Inventor manages the viewport to be the entire
 *   render target, even if the window (for example) is resized.
 *   So this node is useful for rendering objects in a specific part
 *   of the window, for example screen locked annotation graphics
 *   like legends and a "compass".  
 *
 *   Remember that the camera node's @I viewportMapping@i field is set to
 *   ADJUST_CAMERA by default. In this mode the camera automatically adjusts
 *   its view volume to have the same aspect ratio as the viewport (widening for
 *   example) to avoid distorting shapes in the scene. But note that the camera will
 *   compare the aspect ratio of its view volume to the aspect ratio of the viewport
 *   @I that is in effect when the camera node is traversed@i.  So it's generally
 *   better to create a camera for each viewport and make sure the camera node is
 *   traversed after the viewport node.  If using multiple viewports with the same
 *   camera, generally the viewports should all have the aspect ratio.
 *
 *   Tip: You can use the SoDepthBuffer node to clear the depth buffer in the
 *   viewport region to ensure annotation graphics render correctly.
 *   However, in general, you should put an SoViewportClipping node before this
 *   node to limit the effect of the depth buffer clear to the desired viewport.
 *
 *   If you want to place multiple "views" inside the same window,
 *   consider the PoView and PoSceneView nodes.  Views allow the application 
 *   to specify multiple cameras, each with its own separate viewport   
 *   Views can be used, for example, to subdivide the window into multiple 
 *   independent views of a 3D scene or to create an inset "bird's eye" view 
 *   inside the window, without the overhead of creating separate windows. 
 *   The advantage of using the view nodes over SoViewport is that when mouse
 *   event locations are mapped back into 3D space, Open Inventor automatically 
 *   uses the view volume of the camera associated with the view node whose
 *   viewport currently contains the mouse cursor.
 *
 *   @NODE_SINCE_OIV 8.6
 *
 * @FILE_FORMAT_DEFAULT
 *    Viewport {
 *      @TABLE_FILE_FORMAT
 *       @TR origin  @TD (0,0)
 *       @TR size    @TD (0,0)
 *      @TABLE_END
 *    }
 *
 * @ACTION_BEHAVIOR
 *    SoGLRenderAction
 *      Sets: SoViewportRegionElement
 *
 * @SEE_ALSO
 *       SbViewportRegion, SoViewportClipping, SoDepthBuffer, PoView, PoSceneView
 *
 *
 */
class INVENTOR_API SoViewport : public SoNode
{
  SO_NODE_HEADER(SoViewport);

public:

  /**
   * Specifies the position of the viewport in pixels.
   * (Although this is a float field, the values really
   * are pixels, not normalized units.) Default is 0,0.
   */
  SoSFVec2f origin;

  /**
   * Specifies the size of the viewport in pixels.
   * (Although this is a float field, the values really
   * are pixels, not normalized units.) Default is 0,0.
   */
  SoSFVec2f size;

  /** Constructor */
  SoViewport();

SoEXTENDER public:

  /** default actions behavior */
  virtual void doAction(SoAction *action);

  /** @copydoc SoNode::pick */
  virtual void pick(SoPickAction *action);

  /** @copydoc SoNode::callback */
  virtual void callback(SoCallbackAction* action);

  /** @copydoc SoNode::GLRender */
  virtual void GLRender(SoGLRenderAction * action);

  /** @copydoc SoNode::getBoundingBox */
  virtual void getBoundingBox(SoGetBoundingBoxAction* action);

  /** @copydoc SoNode::getMatrix */
  virtual void getMatrix(SoGetMatrixAction* action);

  /** @copydoc SoNode::handleEvent */
  virtual void handleEvent(SoHandleEventAction* action);

SoINTERNAL public:
  /** @copydoc SoNode::initClass. */
  static void initClass();

  /** @copydoc SoNode::exitClass. */
  static void exitClass();

  /**
   * Compatibility with SbViewportRegion which defines window size as well.
   * This value is used during the doAction to set the SoViewportRegionElement.
   */
  SbVec2i32 windowSize;

protected:
  /** Destructor */
  virtual ~SoViewport();
};

#endif /* _SO_VIEWPORT_H_ */


