/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : M.Heck (March 2011)
**=======================================================================*/

#ifndef _SB_CYLINDRICALPROJECTION_
#define _SB_CYLINDRICALPROJECTION_

#include <Inventor/SbLinear.h>
#include <Inventor/SbString.h>
#include <Inventor/projection/SbProjection.h>

/**
 * Cylindrical coordinate projection.
 * 
 * @ingroup Basics
 * 
 * @DESCRIPTION
 * 
 *  This class performs a cylindrical coordinate projection. 
 *
 *  Cylindrical coordinates are: radius, theta (angle), height @BR
 *  Radius and height are 3D units and theta is in radians.
 *
 *  The projection of cylindrical coordinates into XYZ space is:
 *    x = r * cos(theta)
 *    y = r * sin(theta)
 *    z = h
 *
 * @SEE_ALSO
 * 
 *  SbProjection,
 *  SoProjection
 *
 */
class INVENTOR_API SbCylindricalProjection : public SbProjection
{
public:
 
  /**
   * Constructor
   */
  SbCylindricalProjection();

  /**
   * Constructor
   */
  SbCylindricalProjection(SoProjection* node);

  /**
   * Destructor
   */
  virtual ~SbCylindricalProjection();

  /**
   * @copydoc SbProjection::inverse
   */
  virtual void inverse( SbVec3f &point );

  /**
   * Compute projected bounding box
   */
  virtual bool getProjectedBoundingBox( SbBox3f& bbox );

SoEXTENDER_Documented protected:
  /**
  * @copydoc SbProjection::apply
  */
  virtual void apply( SbVec3f &point );
};

#endif // _SB_CYLINDRICALPROJECTION_


