/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/

#ifndef RENDERERRESOURCEMACRO_H
#define RENDERERRESOURCEMACRO_H

#ifndef HIDDEN_FROM_DOC

#include <algorithm>

/**
 * Macro needed by objects managed by inventor::renderer::ResourceManager<> class
 *
 * Parameter m_cacheable specifies if the render resource update can be set into render cache.
 * If a resource has cacheable flag sets to true, the parameter update value lies in
 * the render cache and can change during traversal (noticed with dirty flag is set to true).
 * On the other hand, a resource which has cacheable flag sets to false cannot lie in a
 * render cache and its update is performed at the beginning of a frame rendering (i.e.
 * pre-command) which makes change during traversal impossible.
 *
 */
#define RENDERER_RESOURCE(ClassName)                                    \
  SoINTERNAL public:                                                    \
  typedef void NotificationCallbackFunc(const ClassName* parameter); \
  template<typename ClassType>                                          \
  void registerResourcemanager(const ClassType* resourceManager) const { m_resourceManagers.push_back((void*)resourceManager); } \
  template<typename ClassType>  \
  void unRegisterResourcemanager(const ClassType* resourceManager) const { \
    /* the same resourceManager may be registered several times (in case of multi viewer for ex.) \
     * but only 1 at time should be unregistered. */\
    std::vector<void*>::iterator itResourceManager = std::find(m_resourceManagers.begin(), m_resourceManagers.end(), resourceManager);\
    if ( itResourceManager != m_resourceManagers.end() )\
      m_resourceManagers.erase(itResourceManager);\
  } \
  bool isDirty() const { return m_dirty; } \
  void setDirty(bool dirty) { m_dirty = dirty; } \
  bool isCacheable() const { return m_cacheable; } \
  void setCacheable(bool c) { m_cacheable = c; } \
  void destroyRendererResource() const { \
      /* Copy because s_resourceDestroyCB function may change m_resourceManagers */ \
      std::vector<void*> resourceManagersCpy = m_resourceManagers; \
      for ( size_t i = 0; i < resourceManagersCpy.size(); i++ )\
        s_resourceDestroyCB(this, resourceManagersCpy[i]); \
  } \
  void updateRendererResource() const { \
    if (m_cacheable) \
      m_dirty = true; \
    else \
      for ( size_t i = 0; i < m_resourceManagers.size(); i++ )\
        s_resourceUpdateCB(this, m_resourceManagers[i]); \
  } \
  static void registerResourceManagerCB(void (*resourceUpdateCB)(const ClassName*, void*), void (*resourceDestroyCB)(const ClassName*, void*)) { \
    s_resourceUpdateCB = resourceUpdateCB; \
    s_resourceDestroyCB = resourceDestroyCB; \
  } \
protected:\
  /* List of resource managers managing this ressource. */ \
  /* This is actually a list of ResourceManager<ClassName>* but we cannot add */ \
  /* a build dependency agains ResourceManager here, so use naked void*. */ \
  mutable std::vector<void*> m_resourceManagers; \
  /* Static ptr to ResourceManager::update and destory function. Same reasons that before, */ \
  /* as we cannot add a build depdnendency between ressources and ResourceManager,*/ \
  /* we have to use some ugly callback mechanism. */ \
  /* We also use static callback to avoid storing a per member callback, which may have */ \
  /* significant impact on memory consumption */ \
  static void (*s_resourceUpdateCB)(const ClassName*, void*); \
  static void (*s_resourceDestroyCB)(const ClassName*, void*); \
  mutable bool m_dirty; \
  mutable bool m_cacheable;

/**
 * Initialization of resource members
 */
#define RENDERER_RESOURCE_INIT(isCacheable) \
  m_cacheable = isCacheable; \
  m_dirty = false;

#define RENDERER_RESOURCE_SOURCE(ClassName) \
  void (*ClassName::s_resourceUpdateCB)(const ClassName*, void*) = NULL; \
  void (*ClassName::s_resourceDestroyCB)(const ClassName*, void*) = NULL;

#endif //HIDDEN_FROM_DOC
#endif
