/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Gavin Bell (MMM yyyy)
** Modified by : Paul Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_ALARM_SENSOR_
#define  _SO_ALARM_SENSOR_

#include <Inventor/sensors/SoTimerQueueSensor.h>

/**
 * Triggers a delegate once sometime in the future.
 * 
 * @ingroup sensors
 * 
 * @DESCRIPTION
 *   This type of sensor can be used to schedule a one-time delegate for some time in
 *   the future. The sensor is not guaranteed to be called at exactly that time, but
 *   will be called sometime after the specified time.
 * 
 * @SEE_ALSO
 *    SoOneShotSensor,
 *    SoTimerSensor,
 *    SoTimerQueueSensor,
 *    SbTime
 * 
 * 
 */
class INVENTOR_API SoAlarmSensor : public SoTimerQueueSensor {

 public:
  /**
   * Constructor.
   */
  SoAlarmSensor();

  /**
   * This constructor takes the callback function and data to be
   * called when the sensor is triggered.
   * [OIV-WRAPPER-NOT-WRAP]
   */
  SoAlarmSensor(SoSensorCB *func, void *data);

  /**
   * Destroys the sensor, freeing up any memory associated with it after unscheduling
   * it.
   */
  virtual ~SoAlarmSensor();

  /**
   * Sets the sensor to go off at the specified time. You @B must @b also call
   * schedule() for the sensor to be triggered. If the sensor is already
   * scheduled, it must be unscheduled and then rescheduled for the change in the
   * trigger time to take effect.
   */
  void                setTime(const SbTime &absTime);
  /**
   * Sets the sensor to go off the given amount of time from now. You @B must @b
   * also call schedule() for the sensor to be triggered. If the sensor is
   * already scheduled, it must be unscheduled and then rescheduled for the change in
   * the trigger time to take effect.
   */
  void                setTimeFromNow(const SbTime &relTime);

  /**
   * Returns the time at which the sensor is set to be triggered. This is similar to
   * the @B getTriggerTime @b method, but returns the time even if the sensor has
   * not yet been scheduled.
   */
  const SbTime &      getTime() const                 { return time; }

  // Overrides the regular schedule() method because we have to set
  // up the trigger time first.
  virtual void        schedule();

 private:
  SbTime              time;           // Time sensor is scheduled for
  SbBool              timeSet;        // Whether time value was set

};

#endif  /* _SO_ALARM_SENSOR_ */

