/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_FIELD_SENSOR_
#define  _SO_FIELD_SENSOR_

#include <Inventor/sensors/SoDataSensor.h>

class SoFieldContainer;

/**
 * Sensor class that can be attached to Open Inventor fields.
 * 
 * @ingroup sensors
 * 
 * @DESCRIPTION
 *   Field sensors detect changes to fields, calling a \if_dotnet delegate \else callback \endif function whenever the
 *   field changes. The field may be part of a node, an input of an engine, or a
 *   global field.
 *
 *   See SoDataSensor for general information and code example.
 * 
 * @SEE_ALSO
 *    SoNodeSensor,
 *    SoPathSensor,
 *    SoDataSensor
 * 
 * 
 */
class INVENTOR_API SoFieldSensor : public SoDataSensor {

 public:
  /**
   * Constructor
   */
  SoFieldSensor();

  /**
   * This constructor takes the callback function and data to be
   * called when the sensor is triggered.
   * [OIV-WRAPPER-NOT-WRAP]
   */
  SoFieldSensor(SoSensorCB *func, void *data);

  /**
   * Destroys the sensor, freeing up any memory associated with it after unscheduling
   * it.
   */
  virtual ~SoFieldSensor();

  /**
   * The attach() method makes this sensor detect changes to the given field.
   * See also detach(), getAttachedField()
   */
  void                attach(SoField *field);

  /**
   * The detach() method unschedules this sensor (if it is scheduled) and
   * makes it ignore changes to the scene graph. 
   * See also attach(), getAttachedField()
   */
  void                detach();

  /**
   * The getAttachedField() method returns the field that this sensor is 
   * sensing, or NULL if it is not attached to any field.
   * See also attach(), detach() 
   */
  SoField *           getAttachedField() const        { return field; }

 SoINTERNAL public:
  // Override trigger to evaluate the field we're connected to, just
  // in case the trigger method doesn't get the value.
  virtual void trigger();

 private:
  SoField *           field;          // Field sensor is attached to

  // Propagates modification notification through an instance. This
  // checks to see if the field that triggered notification matches
  // the field we are attached to. (It also checks indices if necessary.)
  virtual void        notify(SoNotList *list);

  // Called by the attached path when it (the path) is about to be deleted
  virtual void        dyingReference();

  // unlocked calls used internally for correct Multithread management
  void detach(SoField* field);
};

#endif  /* _SO_FIELD_SENSOR_ */

