/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _SO_FILE_SENSOR_H
#define  _SO_FILE_SENSOR_H

#include <Inventor/sensors/SoTimerSensor.h>
#include <Inventor/helpers/SbFileHelper.h>

#include <Inventor/STL/map>
#include <Inventor/STL/vector>

/**
 * Sensor that triggers a \if_dotnet delegate \else callback \endif each time a file is changed.
 *
 * @ingroup sensors
 *
 * @DESCRIPTION
 *   File sensors trigger their \if_dotnet delegate \else callback \endif function when a watched file changes.
 *   Files are checked at the interval specified with SoTimerSensor::setInterval.
 *
 *
 * @SEE_ALSO
 *    SoOneShotSensor,
 *    SoAlarmSensor,
 *    SoTimerQueueSensor,
 *    SbTime
 *
 *
 */
class INVENTOR_API SoFileSensor : public SoTimerSensor {

 public:
  /**
   * Default constructor.
   */
  SoFileSensor();

  /**
   * Constructor that takes the callback function and data to be
   * called when the sensor is triggered.
   */
  SoFileSensor(SoSensorCB *func, void *data);

  /**
   * Destroys the sensor, freeing up any memory associated with it after unscheduling
   * it.
   */
  virtual ~SoFileSensor();

  /**
   * Add file to be monitored.  If file does not exist, the method does nothing.
   */
  void addFile(const SbString& filename);

  /**
   * Remove file from monitored list.  If file is not being monitored, the method does nothing.
   */
  void removeFile(const SbString& filename);

  /**
   * Stop monitoring all previously registered files
   */
  void clearFiles();

  /**
   * Return changed file name. @BR
   * Note: Only valid when called from the \if_dotnet delegate \else callback \endif function.
   */
  inline SbString getFilename() const { return m_currentFile; }

protected:
  /** Check if some files changed */
  virtual void trigger();

private:
  using SoTimerSensor::setBaseTime;
  using SoTimerSensor::getBaseTime;

  typedef std::pair<SbString, SbFileHelper::Stat> FullPathStatPair;
  typedef std::map<SbString, FullPathStatPair> FileStatMap;

  void triggerFile(SbString string);

  std::vector<SbString> m_touchedFiles;

  FileStatMap m_fileStat;

  /** File name for which we have launched a trigger */
  SbString m_currentFile;
};

#endif

