/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Nick Thompson (MMM yyyy)
** Modified by : Paul Strauss (MMM yyyy)
** Modified by : Gavin Bell (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_TIMER_QUEUE_SENSOR_
#define  _SO_TIMER_QUEUE_SENSOR_

#include <Inventor/sensors/SoSensor.h>
#include <Inventor/SbTime.h>

/**
 * Abstract base class for sensors dependent on time.
 * 
 * @ingroup sensors
 * 
 * @DESCRIPTION
 *   Timer queue sensors are sensors that trigger themselves at specific times. The
 *   timer queue is normally processed as part of a program's main loop when the
 *   program is not busy doing something else. Note that processing the timer queue
 *   is not asynchronous - the program must re-enter its main loop for timers to be
 *   triggered. When the timer queue is processed, all timers scheduled to go off at
 *   or before the current time are triggered once, in order from earliest to latest.
 * 
 * @SEE_ALSO
 *    SoTimerSensor,
 *    SoAlarmSensor,
 *    SoIdleSensor,
 *    SoOneShotSensor,
 *    SoDataSensor
 * 
 * 
 */
class INVENTOR_API SoTimerQueueSensor : public SoSensor {

 public:
  /**
   * Constructor.
   */
  SoTimerQueueSensor();
  /**
   * Constructor that takes standard callback function and data.
   */
  SoTimerQueueSensor(SoSensorCB *func, void *data);

  // Destructor
#ifndef HIDDEN_FROM_DOC
  virtual ~SoTimerQueueSensor();
#endif // HIDDEN_FROM_DOC

  /**
   * Returns the time at which this sensor is scheduled to be triggered. If the
   * sensor is not scheduled the results are undefined.
   */
  const SbTime &      getTriggerTime() const          { return trigTime; }

  /**
   * Adds this sensor to the timer queue. Subclasses provide methods for setting when
   * the sensor will be triggered.
   */
  virtual void        schedule();
  /**
   * If this sensor is scheduled, removes it from the timer queue so that it will not
   * be triggered.
   */
  virtual void        unschedule();

 protected:
  // Used by subclasses to set the time at which the sensor is to be
  // triggered.
  void                setTriggerTime(const SbTime &time);

 private:
  SbTime              trigTime;       // Time when sensor is to be triggered

  // Returns TRUE if this sensor should precede sensor s in the delay
  // queue: it must have a lower priority number than s.
  virtual SbBool      isBefore(const SoSensor *s) const;
};

#endif  /* _SO_TIMER_SENSOR_ */

