/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Nicolas DAGUISE (Oct 2005)
**=======================================================================*/


#include <Inventor/SoType.h>

/*************************************************************************/
// SO_PERF_COUNTER_HEADER macro.
// Description :
//  Defines common methods and definition for all stats commands.
//  The macro takes one parameter: the class.
//-------------------------------------------------------------------------
#define SO_PERF_COUNTER_HEADER(className) \
public: \
  static void initClass(); \
  static void exitClass(); \
  static SoType getClassTypeId(); \
  virtual SoType getTypeId() const; \
private:  \
  static SoType m_classTypeId;

/*************************************************************************/
// SO_PERF_COUNTER_SOURCE macro.
// Description :
//  Defines common methods and definition for all stats commands.
//  The macro takes two parameters:
//  - the class
//  - the inherited class
//-------------------------------------------------------------------------
#define SO_PERF_COUNTER_SOURCE(className, inheritClass) \
SoType className::m_classTypeId; \
void className::initClass() { \
  if (m_classTypeId.isBad()) { \
    if (inheritClass::getClassTypeId().isBad() ) \
      inheritClass::initClass(); \
    m_classTypeId = SoType::createType(inheritClass::getClassTypeId(), #className);  \
    m_classTypeId.makeInternal(); \
  } \
} \
void className::exitClass() { \
  if (m_classTypeId != SoType::badType()) { \
    SoType::removeType(m_classTypeId.getName());  \
    m_classTypeId = SoType::badType(); \
  } \
} \
SoType className::getClassTypeId() { return className::m_classTypeId; } \
SoType className::getTypeId() const { return className::m_classTypeId; }
/**/


