/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Julien Chaplier (MMM yyyy)
**=======================================================================*/

#ifndef _SB_THREAD_RW_MUTEX_H_
#define _SB_THREAD_RW_MUTEX_H_

#if defined(_WIN32)
#pragma warning( push )
#pragma warning( disable: 4251 ) // 'identifier' : class 'type' needs to have dll-interface to be used by clients of class 'type2'
#endif

#include <Inventor/SbBase.h>
#include <Inventor/SbPImpl.h>

// keep this header for compatibility purpose
#include <Inventor/threads/SbThread.h>
#include <Inventor/threads/SbThreadSpinlock.h>
#include <Inventor/threads/SbThreadAutoLock.h>

SO_PIMPL_BASE_PUBLIC_DECLARATION(SbThreadRWMutex)

/**
 * @VSGEXT Portable readers/writer lock class.
 * 
 * @ingroup Threads
 * 
 * @DESCRIPTION
 *   This class provides read/write blocking. It is implemented using the pthreads
 *   API on UNIX/Linux and the Win32 API on Microsoft Windows.
 *   
 *   A readers/writer lock works like this: @BR
 *   Any number of threads can hold a read lock on this object at the same time.
 *   While any thread holds a read lock on this object, all requests for a write
 *   lock will block.  Conversely, only one thread can hold a write lock on this
 *   object at any time.  While a thread holds a write lock on this object, all
 *   requests for a read lock @I by other threads @i will block.  As a convenience,
 *   the thread holding the write lock may obtain any number of read locks, as long
 *   as all read locks are released before the write lock is released.
 *
 *   A readers/writer lock is appropriate for a resource that is frequently "read"
 *   (its value accessed) and is not often modified.  Particularly if the "read"
 *   access must be held for a significant amount of time.  (If all accesses, both
 *   read and write, are quite short then it may be more efficient to use the
 *   SbThreadMutex class.)  For example, the SoDB::readlock and SoDB::writelock
 *   methods use an SbThreadRWMutex to control access to the scene graph.  All
 *   Open Inventor actions automatically call SoDB::readlock to gain read access
 *   before beginning a traversal.  This allows, for example, multiple render
 *   threads to safely traverse ("read") the scene graph in parallel.
 *
 *   Generally, acquiring a read or write lock on an SbThreadRWMutex is more
 *   expensive (takes more time) than acquiring a lock on an SbThreadMutex.
 *   As with any synchronization object, failure to release a lock will usually
 *   result in a "deadlock" situation that prevents the application from running.
 *   SbThreadAutoReadLock and SbThreadAutoWriteLock provide a "safe" way to
 *   acquire a lock that will be automatically released when the object goes
 *   out of scope.
 *   
 *   It is not necessary to use this class in order to use multiple threads with Open
 *   Inventor. It is provided only as a convenience. (However, note that you should
 *   use pthreads on UNIX/Linux and Win32 on Windows to be certain of compatibility
 *   with Open Inventor.)
 * 
 * @SEE_ALSO
 *    SbThread,
 *    SbThreadAutoLock,
 *    SbThreadAutoReadLock,
 *    SbThreadAutoWriteLock,
 *    SbThreadBarrier,
 *    SbThreadMutex
 *
 * [OIV-WRAPPER-CLASS NO_WRAP]
 */ 
class INVENTORBASE_API SbThreadRWMutex
{
  SO_PIMPL_BASE_PUBLIC_HEADER( SbThreadRWMutex );

 public:
  /**
   * Create a read/write mutex.
   */
  SbThreadRWMutex();

#if SoDEPRECATED_BEGIN(10000)
  SoDEPRECATED_METHOD(10000, "The 'force' parameter is no longer used. The default constructor should be used instead.")
  SbThreadRWMutex( const SbBool force );
#endif /** @DEPRECATED_END */

  /**
   * Destructor.
   */
  ~SbThreadRWMutex();

  /**
   * Request a write lock (exclusive access) for this mutex. Returns zero if
   * successful.
   */
  int writelock();

  /**
   * Release a write lock. Returns zero if successful.
   */
  int writeunlock();

  /**
   * Request a read lock (non-exclusive access) for this mutex. Returns zero if
   * successful.
   */
  int readlock();

  /**
   * Release a read lock. Returns zero if successful.
   */
  int readunlock();

SoINTERNAL public:

  // returns if someone has a lock on this mutex (even current thread)
  // it is particularly usefull to check if the mutex can be deleted or not.
  SbBool isUsed() const;

  // version adapted for r/w try-locking. It is a little slower
  // than the regular trylock. Synonymous for trywritelock. No
  // trylock should be done within a readlock on the same mutex.
  // !!! Not fully implemented
  SbBool trywritelock();

  // Equivalent to readlock but does not block if the reader cannot
  // lock the mutex and returns FALSE. Otherwise returns TRUE.
  // !!! Not fully implemented
  SbBool tryreadlock();

private:
  // no copy constructor
  SbThreadRWMutex(const SbThreadRWMutex&);
};

#if defined(_WIN32)
#pragma warning( pop )
#endif

#endif //_SB_THREAD_RW_MUTEX_H_


