/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Nicolas DAGUISE (May 2007)
**=======================================================================*/


#ifndef SB_THREAD_SIGNAL_H
#define SB_THREAD_SIGNAL_H

#include <Inventor/sys/port.h>
#include <Inventor/SbBase.h>

#include <Inventor/threads/SbThreadSpinlock.h>

class SbThreadMutex;

#if !defined (WIN32)
#include <pthread.h>
#endif

/**
 * @VSGEXT Portable signal class.
 *
 * @ingroup Threads
 *
 * @DESCRIPTION
 *   This class provides a portable "condition variable" object. Condition variables
 *   are used when one thread wants to wait until another thread has finished doing
 *   something: the first thread "waits" on the condition variable, the second thread
 *   "signals" the condition variable when it is done. It is implemented
 *   using the pthreads API on UNIX/Linux and the Win32 API on Microsoft Windows.
 *
 *   It is not necessary to use this class in order to use multiple threads with Open
 *   Inventor. It is provided only as a convenience. However, note that you should
 *   use pthreads on UNIX/Linux and Win32 on Windows to be certain of compatibility
 *   with Open Inventor.
 *
 * @SEE_ALSO
 *    SbThreadAutoLock,
 *    SbThreadBarrier,
 *    SbThreadMutex,
 *    SbThreadRWMutex
 *
 * [OIV-WRAPPER-CLASS NO_WRAP]
 */
class INVENTORBASE_API SbThreadSignal
{
public:

  /**
   * Constructor.
   */
  SbThreadSignal( SbThreadMutex* mtx );

  /**
   * Destructor.
   */
  ~SbThreadSignal( );

  /**
   * Signals one thread that is waiting on this object.
   */
  void signalOne( );

  /**
   * Signals all threads that are waiting
   * on this object.
   */
  void signalAll( );

  /**
   * Waits for a signal notification. When called, it goes to sleep
   * awaiting a subsequent notification from another thread (via the
   * signalOne or signalAll methods).
   */
  void wait( );

  /**
   * Waits for a signal notification or timeout milliseconds have elapsed.
   * If the timeout elapses before the signal is notified, the function
   * returns FALSE to the caller, signifying that a timeout has occurred.
   */
  SbBool trywait( const unsigned int timeout_ms );

private:
  SbThreadMutex* m_signalMtx;

#if defined(_WIN32)
  HANDLE m_events[2];
  uint32_t m_waitersCount;
  SbThreadSpinlock m_spinlock;

#elif defined (__linux__) || defined(__APPLE__)
  pthread_cond_t m_event;
  bool m_automatic;
  bool m_active;

#else
  // Not implemented yet.
#endif
};

#endif // SB_THREAD_SIGNAL_H

/**/


