#ifndef HIDDEN_FROM_DOC

/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Nicolas DAGUISE (Oct 2008)
**=======================================================================*/


#ifndef _SB_THREAD_STORAGE_BASE_H_
#define _SB_THREAD_STORAGE_BASE_H_

#include <Inventor/SoInventorBase.h>
#include <Inventor/threads/SbThreadLocalStorage.h>
#include <Inventor/threads/SbThreadSpinlock.h>
#include <Inventor/STL/list>
#include <deque>

#if defined(_WIN32)
#pragma warning( push )
#pragma warning(disable:4251)
#endif //_WIN32

// Opaque storage structure to handle the list of SbThreadStorageBase
class SbThreadStorageMapStruct;

/**
 * @VSGEXT Abstract base class for per instance thread Local Storage.
 *
 * see SbThreadStorage.
 *
 * [OIV-WRAPPER-CLASS NO_WRAP]
 */
class INVENTORBASE_API SbThreadStorageBase
{
  SB_THREAD_TLS_HEADER();

public:

  /** Clear this storage. */
  void cleanStorage();

protected:
  /** Constructor */
  SbThreadStorageBase();
private:
  /** Forbid copying */
  SbThreadStorageBase(const SbThreadStorageBase& tocopy);
protected:
  /** Destructor */
  virtual ~SbThreadStorageBase();

  /** release memory of a single value */
  virtual void deleteStorage(void* p) = 0;

SoINTERNAL public:
  /** static initializer */
  static void initClass();
  /** static finisher */
  static void exitClass();

  void* getValue() const;
  void Register( void* );

  typedef std::list< SbThreadStorageMapStruct* > SbThreadStorageGlobalList;

  struct MTstruct
  {
    SbThreadStorageMapStruct* threadStorageMapStruct;
  };

protected:
  // helper to erase all values of a storage
  void erase();
  // helper to set the value for the current thread
  void setAll(void* p);
  // helper to get the value for the current thread
  void* get (const SbThreadStorageGlobalList::const_iterator& it_i);

  // global list to keep track of all storage
  static SbThreadStorageGlobalList s_threadStorageGlobalList;
  // mutex for s_threadStorageGlobalList access
  static SbThreadSpinlock s_threadStorageGlobalMutex;

private:
  // ID in the storage (same in all thread)
  size_t m_storageID;

  // get an available storage ID
  static size_t getID();

  // last ID available.
  // Must access with lock for thread-safety.
  static size_t s_storageID;

  // list of ID previously used and available for reuse.
  // if none are available then s_storageID is used and incremented for next round.
  // Must access with lock for thread-safety.
  typedef std::deque<size_t> SbThreadStorageFreeIDList;
  static SbThreadStorageFreeIDList s_freeStorageIDList;
};

#if defined(_WIN32)
#pragma warning(pop)
#endif //_WIN32


#endif //_SB_THREAD_STORAGE_BASE_H_


#endif // HIDDEN_FROM_DOC

/**/
