 /*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/



#ifndef  _SO_WIN_TOUCH_SCREEN
#define  _SO_WIN_TOUCH_SCREEN

#include <windows.h>

#include <Inventor/Win/devices/SoWinDevice.h>
#include <Inventor/touch/events/SoTouchEvent.h>
#include <Inventor/Win/SoWin.h>
#include <Inventor/Win/SoWinRenderArea.h>
#include <Inventor/touch/SoTouchManager.h>

/**
 * Translates and reports windows messages for the touch screen device.
 * 
 * @ingroup touch
 * 
 * @DESCRIPTION
 *   This class represents a touch screen input device for the Microsoft Windows OS.
 *   It translates and manages messages generated by the touch screen. 
 *   When the touch screen device is registered in an SoWinRenderArea, the device is able
 *   to generate Open Inventor touch events (see SoTouchEvent) and gesture events 
 *   (see SoGestureEvent) that can be handled (for example) using an SoEventCallback node. 
 *
 *   It analyses each touch event and updates events in the SoTouchEvent table of SoTouchManager.
 *
 *   @B Note@b: Unlike SoWinMouse and SoWinKeyboard, this device must be explicitly registered
 *   with the render area / viewer by the application.
 *
 * @EXAMPLE
 *   \if_cpp
 *     \code
 *     Widget mainWindow = SoWin::init(argv[0]);
 *     . . .
 *     SoWinExaminerViewer* viewer = new SoWinExaminerViewer( mainWindow );
 *     SoWinTouchScreen touchScreenDevice( mainWindow );
 *     viewer->registerDevice( &touchScreenDevice );
 *     \endcode
 *   \endif
 *   \if_dotnet
 *     \code
 *     SoWinExaminerViewer viewer = new SoWinExaminerViewer( this );
 *     SoWinTouchScreen touchScreenDevice = new SoWinTouchScreen( this );
 *     viewer.RegisterDevice( touchScreenDevice );
 *     \endcode
 *   \endif
 *   \if_java
 *     Not available
 *   \endif
 *
 * @SEE_ALSO
 *    SoWinDevice,
 *    SoTouchManager,
 *    SoTouchEvent,
 *    SoGestureEvent
 */
class INVENTORW_API SoWinTouchScreen : public SoWinDevice{

public:
  /** Constructor */
  SoWinTouchScreen(SoWidget myWindow);

  /** Destructor */
  virtual ~SoWinTouchScreen();
    
  /** @copydoc SoWinDevice::enable() */
  virtual void enable(SoWidget w, XtEventHandler f,
                      XtPointer data, Window win = NULL);

  /** @copydoc SoWinDevice::disable() */
  virtual void disable(SoWidget w, XtEventHandler f, XtPointer data);

  /** @copydoc SoWinDevice::translateEvent() */
  virtual const SoEvent * translateEvent(XAnyEvent *xe);

  /**
   * Returns the SoTouchManager.
   * This object contains the events table, recognizers list and methods to use them.
   */
  SoTouchManager* getTouchManager() const;

private:
  SoTouchManager* m_touchManager;

  SoTouchEvent* translateTouchEvent(XEvent * xe);
		
  SoWidget m_myWindow;
  SoWinRenderArea* m_renderArea;

};


#endif /* _SO_WIN_TOUCH_SCREEN */

