/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2025 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _SO_MEDIATOR_
#define _SO_MEDIATOR_

#ifdef _MSC_VER
#pragma warning( push )
#pragma warning(disable:4251)
#endif

#include <Inventor/STL/vector>
#include <Inventor/SbBox.h>
#include <LDM/SoLDMTileID.h>
#include <LDM/SoLDMResourceManager.h>
#include <LDM/nodes/SoLDMResourceParameters.h>

#include <LDM/SoLDMDataAccess.h>

#include <LDM/elements/SoDataSetElement.h>


// LDM
class SoLDMTileVisitor;
class SoLDMProximityVisitor;
class SoLDMMultiIOTileManager;
class SoLDMNodeFrontManager;
class SoLDMTextureManager;
class SoLDMGeometry;
class SoLDMResourceManager;
class SoDataCompositor;
class LDMDefaultSliceAccessor;
class SoGLRenderAction;
class SoDataSet;
class SoState;
class SoLdmParameterNode;
class SoBufferObject;
class SbThreadSemaphore;
class SoDataSetId;
class SoLdmValuationAction;
class SoLDMTileInfo;
class SoLDMTileManager;
class LDMSliceAccessor;


/**
 * @LDMEXT Large Data Management
 *
 * @ingroup LDM
 *
 * @DESCRIPTION
 *
 * This class is only needed for advanced users who intend to extend or replace
 * internal LDM algorithms.
 *
 * This class is used by the LDM (Large Data Management)
 * managers to communicate with each other.
 *
 * @SEE_ALSO
 *   SoDataSet
 */
SoINTERNAL class LDM_API SoLDMMediator
{
public:
  /** Constructor */
  SoLDMMediator();

  /** Destructor */
  virtual ~SoLDMMediator();

SoEXTENDER public:

  void registerNode(const SoLDM::DataSetIdPair& dsIdPair, bool sync);
  void unregisterNode(const SoLDM::DataSetIdPair& dsIdPair, SoLDMMediator *newMediator = NULL);

  void readTile(int dataSetId, SoLDMTileID tileID, unsigned char* buffer, bool transform) ;

  void readTile(const int dataSetId, const SoLDMTileID tileID, SoBufferObject* buffer, const bool transform) ;

  size_t readTile(SoLDMTileInfo* tileInfo, const int dataSetId, bool transform);

  uint64_t getTileSize(int dataSetId, const SoLDMTileID* tileId = NULL)const ;
  SbVec3i32 getTileDimension()const ;

  const SbVec3i32& getDimension()const ;
  const SbBox3f&   getExtent()const ;
  int getOverlapping() const
  {
    return 0;
  }

  void renderNotify()const;

  /**
   * Returns a vector containing the current data set Ids.
   */
  const std::vector<int>& getNumData() const ;

  SbBool getBbox(SoLDMTileID tileID, SbBox3f& box)const;
  bool getCenter(SoLDMTileID tileID, SbVec3f& center)const;

  //stuff I dont know what to do with yet
  SbBool getListChange(){return m_listChange;};

  ////// for multi-data //////
  int getDataEntry(unsigned short id)const ;
  int getDataEntry(SoDataSet*)const ;

  /** Return true if volume don't have the same tile size, etc... */
  bool hasMultiDataError() const
  {
    return m_multiDataError;
  }

  ////////////////////////////
SoINTERNAL public:

  /** Register given dataset with the list of ids */
  void registerWithIds(SoDataSet* ds, std::vector<int> ids, bool sync);

  /** Unregister all ds/id pair with the given ds */
  void unregisterAllIds(SoDataSet* ds, SoLDMMediator* newMediator = NULL);

  /** Remove all dataset */
  void unregisterAll();

  SoLDMTileManager* getTileManager() { return m_tileManager; }
  SoLDMTextureManager*  getTextureManager() { return m_textureManager; }
  SoLDMGeometry*    getVVizGeometry() { return m_vvizGeometry; }
  SoLDMNodeFrontManager* getNodeFrontManager() { return m_nodeFrontManager; }

  LDMSliceAccessor* getSliceAccessor(const SoLDM::DataSetIdPair& p)const;
  void startRenderTraversal(SoLdmValuationAction*, SoDataSet*);

  void updateRegions(const SbBox3i32* region, int numRegions);
  /*
   * This function will only be called if in multiple data mode.
   * Called to check if the list of SoDataSet currently stored in the state are also in the list
   * of data set registered to this tile manager (subsequent calls to registerVolumeData).
   * Allows to detect scene graph change ( e.g. a switch node was turned off, the SoDataSet under
   * the switch node is still registered in the tile manager but is not part of the state anymore ).
   * The data compositor present in the state (if any) is also passed to check if it corresponds to the one
   * used by the tile manager (getVolumeData()->getDataCompositor()).
   * If any change occured, tile manager's state must be set accordingly.
   */
  void checkList(SoAction* action, SoDataCompositor* dc);

  //Return the biggest buffer id in the m_volumeDataList. When a dataset is no more in the
  //state but is still registered(because of a switch change or a delayed delete in ScaleViz)
  //this number is different from m_volumeDataList.size()-1. So this is this value which must
  //be used for SoLDMTileInfo::extendNumBuffer(int).
  //Ex: bufferIDs(0, 1, 2) -> bufferIDs(0, 2) and m_volumeDataList.size(3) -> m_volumeDataList.size(2)
  int getBiggestBufferEntry() const;

  //Do a start/endNumDataNotify without sync in order to be sure that SoLDMMultiIOTileManager::loadingThreadRoutine
  //is running (if there is at least one dataset registered)
  void restartLoadingThread();

  // SoDataSet ids vectors
  void updateDataIds() ;

  SoDataSet* getVolumeOfId(unsigned short dataSetId)const;
  void getVolumeElements(SoLDM::DataSetIdPairList& dsIdPairList) const;

  /** Return the list of registered dataset without their ids */
  void getDataSetList(SoLDM::DsVector& dsList) const;

  /** Return ids associated to given dataset */
  void getDataSetIds(const SoDataSet* ds, std::vector<int>& ids) const;

  /**
   * Returns the first data set registered in data set list.
   */
  SoDataSet* getFirstDataSet() const
  {
    if (m_volumeDataList.empty())
      return NULL;

    return m_volumeDataList[0].dsIdPair.first;
  }

  /**
   * Returns the first data set id pair registered in data set list.
   */
  const SoLDM::DataSetIdPair& getFirstDataSetIdPair() const;

  /**
   * Returns a vector containing the current dataset/Id pairs
   */
  const SoLDM::DataSetIdPairList& getDsIds() const
  {
    return m_dataDsIds;
  }

  //After this call, data handled by this mediator will be loaded by LDM's threads
  void addToLDM();

  SoDataCompositor* getDataCompositor()const { return m_dc; }
  void setDataCompositor(SoDataCompositor *dc);

  /// multi-data list ////
  struct DataSetInfo
  {
    SoLDM::DataSetIdPair dsIdPair;
    int bufferId;
  };
  typedef std::vector<DataSetInfo> DataSetInfoList;

  DataSetInfoList & getVolumeDataList();

  /**
   * Allow to perform correct initialization when switching from fixed/non fixed
   * resolution. Mainly used by LDMResourceParameters to manage internal tile
   * visitor management. Return true if current tile visitor has been set to manage
   * fixed resolution. False otherwise.
   */
  bool isAlreadyInFixResMode() const
  {
    return m_isTileVisitorFixedRes;
  }

#if SoDEPRECATED_BEGIN(9700)
  /**
  * mark the current tile visitor to know its usage
  * if flag is set to true, the tile visitor is used for fixed resolution
  * false means LDM is currently not running in fixed resolution
  */
  SoDEPRECATED_METHOD( 9700, "LDM Tile Visitor is no longer used." )
  void useFixedTileVisitor(bool flag)
  {
    m_isTileVisitorFixedRes = flag;
  }
#endif /** @DEPRECATED_END */

  /**
   * Allows you to provide an application-defined subclass of SoLDMTileVisitor.
   * Passing NULL sets the visitor to the LDM internal default visitor (SoLDMProximityVisitor).
   * By default, LDM will not gain ownership of a custom tile visitor, but it is
   * possible to let LDM handle the deletion of the tile visitor by passing FALSE as
   * the second parameter (ownedByUser). Note when a dataset is added under a MultiDataSeparator
   * the mediator of this dataset is unregistered. The only mediator taken in account
   * is the one associated to the MultiDataseparator and, as a result, custom tile visitor set
   * previously is not available anymore. It is then mandatory to set this custom tile visitor
   * on the global mediator.
   */
  void setTileVisitor( SoLDMTileVisitor* visitor, bool ownedByUser = true );

  /**
   *
   * Allows you to provide an application-defined subclass of SoLDMTileManager.
   * By default, LDM will not gain ownership of a custom tile manager, but it is
   * possible to let LDM handle the deletion of the tile manager by passing FALSE as
   * the second parameter (ownedByUser).
   */
  void setTileManager( SoLDMTileManager* tilemgr, SbBool ownedByUser = TRUE );

  /**
   * Returns a pointer to the application-defined subclass of SoLDMTileVisitor.
   */
  SoLDMTileVisitor* getTileVisitor()
  {
    return m_tileVisitor;
  }

  /**
   * Returns true if the attached tileVisitor set by the application is owned by it.
   */
  bool isTileVisitorOwnedByUser() const { return m_userVisitor; }

  /**
   * @brief Return true if we are doing multi data.
   * @detail Multi data is performed in case on the state there is different data set ids
   * belonging to this mediator.
   * @param state the state
   */
  bool isDoingMultiData(SoState* state);

private:
  SoLDMTextureManager* m_textureManager;
  SoLDMGeometry* m_vvizGeometry;
  SoDataCompositor* m_dc;
  SoLDMTileVisitor* m_tileVisitor;
  SoLDMNodeFrontManager* m_nodeFrontManager;
  SoLDMTileManager* m_tileManager;

  //for user defined LDM component
  bool m_userVisitor;
  SoLDMProximityVisitor*   m_internalVisitor;
  bool m_userTileManager;
  SoLDMMultiIOTileManager* m_internalTileManager;

  const DataSetInfo& getDataInfo(const SoLDM::DataSetIdPair& dsIdPair) const;

  bool isUsedByLDM() { return m_isUsedByLDM; }
  void setUsedByLDM(bool flag) { m_isUsedByLDM = flag; }
  bool m_isUsedByLDM;

  /** vector containing the current volume Ids */
  std::vector<int> m_dataIds ;
  SoLDM::DataSetIdPairList m_dataDsIds;

  std::vector<DataSetInfo> m_volumeDataList;
  bool isInList(const SoLDM::DataSetIdPair& dsIdPair)const;

  // Available buffer entries (ie id) for data
  std::vector<int> m_availBufferEntry;

  void addToList(const SoLDM::DataSetIdPair& dsIdPair);
  void removeFromList(const SoLDM::DataSetIdPair& dsIdPair);
  void setListChange(bool val){m_listChange = val;};
  bool m_listChange;
  /////////////////////////

  void createLDMCore();
  void deleteLDMCore();

  void setMinResolutionThreshold();

  /**
   * Returns true if dataset list can be used in multidata mode.
   * (check tilesize, tile dim)
   */
  bool isMultiDataPossible();

  /** True if there is a multidata error */
  bool m_multiDataError;

  /** If true display debug infos */
  static int s_debugMediator;

SoINTERNAL public:
  SoLDMDataAccess&        getDataAccess ( int id = -1 );
  SoLDMDataAccess&        getDataAccess ( SoDataSet* ds );

  /** Get resource manager associated to given DataSetId.
   * If given id is < 0, return manager of 1st DataSet in DataSet list, which generally doesn't correspond to the one you want... */
  SoLDMResourceManager* getResourceManager(int id);

  SoLDMResourceParameters* getResourceParameter( int dataEntry );
  SoLDMResourceParameters* getFirstResourceParameter();

private:

  bool m_isTileVisitorFixedRes;

  // We use a map of LDMDataAccess to be able to
  // support multi thread. One Data Access per thread id
  typedef std::map<SbThreadId_t, SoLDMDataAccess*> t_dataAccessList;

  t_dataAccessList m_ldmDataAccessList;
  SbThreadMutex* m_semDataAccessList;

};

#ifdef _MSC_VER
#pragma warning( pop )
#endif

#endif


