/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/


#ifndef SO_LDM_GZIP_COMPRESSOR_H
#define SO_LDM_GZIP_COMPRESSOR_H

#include <LDM/compressors/SoDataCompressor.h>

class SoZlib;

/**
* @LDMEXT Gzip data compression
* @ingroup LDMCompressor
*
* @DESCRIPTION
*
* This class implements a compression scheme based on zlib. It is a
* lossless compression and can be used on any data set type.
*
* The setCompressionLevel method (inherited from SoDataCompressor
* or in SoConverterParameters) accepts values between 0 and 9.
* 0 gives no compression, 9 gives best compression but slower speed.
* Default is 3.
*
* @SEE_ALSO
* SoJpegDataCompressor,
* SoDataCompressor,
* SoConverterParameters
*
*
*/
class LDM_API SoGzipDataCompressor : public SoDataCompressor
{
  SO_TYPED_CLASS_HEADER();

public:
  /**
   * Constructor.
   */
  SoGzipDataCompressor();

  /**
   * Destructor.
   */
  virtual ~SoGzipDataCompressor();

  /**
   * Compresses the given buffer into the internal buffer.
   * @param src a pointer to the data to compress.
   * @param srcLen the size of the source buffer in bytes.
   * @param tileInfo contains information about the tile being processed.
   * @return The size in bytes of the compressed buffer.
   */
  virtual size_t compress(void *src, size_t srcLen, const TileInfo &tileInfo);

  /**
   * Uncompresses data from the internal buffer to the given buffer.
   * @param dest a pointer to the destination buffer.
   * @param destLen the size of the destination buffer.
   * @param tileInfo contains information about the tile being processed
   * @return The number of uncompressed bytes.
   */
  virtual size_t uncompress(void *dest, size_t destLen, const TileInfo &tileInfo);

  /**
   * Returns the name of the compression algorithm used by this class.
   * This is the name the user must pass to the "-c" option of the converter
   * to use this compression ("gzip" here).
   * @return An SbString containing "gzip".
   */
  virtual SbString getCompressionFormatName() const { return SbString("gzip"); }

  /**
   * This compression is lossless.
   * @return true, the compression is lossless.
   */
  virtual bool isLossless() { return true; }

private:
  size_t allocateNeededSpace(size_t srcLen);

  SoZlib* m_zlib;
};

#endif


