/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

  
#ifndef  _SO_DATA_COMPOSITOR_ELT__
#define  _SO_DATA_COMPOSITOR_ELT__

#include <Inventor/elements/SoReplacedElement.h>

class SoDataCompositor;

/**
 * @ingroup LDMElements
 */
class LDM_API SoDataCompositorElement : public SoReplacedElement {
  SO_ELEMENT_HEADER( SoDataCompositorElement );

public:

  // Sets/Gets the current volume data attributes in the state
  static void set(SoState* state, SoNode *node, SoDataCompositor*);
  static void get(SoState* state, SoDataCompositor*&);

  // Default values
  static void getDefault(SoDataCompositor*&);

protected:

  /** Initializes element */
  virtual void init(SoState* state);

  SoINTERNAL public:
  // Initializes the SoVolumeData class
  static void initClass();
  static void exitClass();

  /** return true if current compositor transform data in RGBA mode */
  static bool isRGBA(SoState* state);

protected:
  virtual void setElt( SoDataCompositor *m_dataCompositor );

  virtual ~SoDataCompositorElement() ;

private:
  SoDataCompositor *m_dataCompositor;

};

#endif // _SO_DATA_COMPOSITOR_ELT__


