/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2025 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : P. ESTRADE (Feb 2000)
** Modified by : J. HUMMEL to collect multiple volume data node (Apr 2005)
**=======================================================================*/


#ifndef  _SO_DATA_SET_ELEMENT_
#define  _SO_DATA_SET_ELEMENT_

#include <Inventor/nodes/SoShaderParameter.h>
#include <Inventor/elements/SoReplacedElement.h>
#include <Inventor/SbBox.h>
#include <Inventor/SbLinear.h>
#include <Inventor/STL/vector>
#include <Inventor/STL/set>
#include <Inventor/STL/map>

#include <LDM/SoLDM.h>

#ifdef _MSC_VER
#pragma warning( push )
#pragma warning(disable:4251)
#endif

class SoDataSet;
class SoNode;
class SoLDMTileManager;
class SoState;
class SoDataSetId;
class SoGLRenderAction;
class SoLDMMediator;

//wrapper
/**
 * @ingroup LDMElements
 */
class LDM_API SoDataSetElement : public SoReplacedElement {

  SO_ELEMENT_HEADER( SoDataSetElement );

public:

  /** Overrides push() method to copy values from next instance in the stack */
  virtual void push(SoState *state);

  // Sets the current volume data attributes in the state
  static void set(SoState* state, SoNode *node, SoDataSet *datasetNode);
  static void set(SoState *state, SoNode *node,
                  SoDataSet *datasetNode, const SbMatrix &matrix );

  //Get the current list of volume data stored in the state
  static void get(SoState* state, std::vector<SoDataSet*>&);
  /** [OIVJAVA-WRAPPER NAME{getDataSet}] */
  static void get(SoState* state, SoDataSet*& ds);

  static void get(SoState* state, SoLDM::DataSetIdPairList& dataSetIdPairList);

  // Returns current model matrix from the state, sets given flag to TRUE
  // if matrix is known to be identity
  static const SbMatrix &get(SoState *state, SoDataSet*&, SbBool &isIdent );

  // Default values
  static void getDefault(SoLDM::DataSetIdPair&);

protected:

  /** Initializes element */
  virtual void init(SoState* state);

  /**
   * Returns TRUE if the element matches another element, based on node-id.
   */
  virtual SbBool matches(const SoElement* elt) const;

  /** Create and return a copy of this element. */
  virtual SoElement* copyMatchInfo() const;

SoINTERNAL public:
  typedef std::pair<SoDataSet*, const SoDataSetId*> DataSetPtrIdPair;

  // Initializes the SoDataSet class
  static void initClass();
  static void exitClass();

  static void reset(SoState*);

  /** Return true if doing multidata */
  static bool isDoingMultiData(SoState* state);

  /** Return true if doing Cpu data composition */
  static bool isDoingCpuComposition(SoState* state);

  /** Return the dataset/id pair currently on state with the given type (SoVolumeMask,SoVolumeData... */
  template<typename T>
    static std::pair<T*, int> getLastOfType(SoState* state, bool derived)
  {
    SoLDM::DataSetIdPair p = getLastOfType(state, T::getClassTypeId(), derived);
    return std::make_pair(static_cast<T*>(p.first), p.second);
  }

  //get the current tile manager stored in the state
  /** [OIVJAVA-WRAPPER NAME{getTileManager}] */
  static void get( SoState* state, SoLDMTileManager*& );

  /** Group DataSet per LDMMediator */
  static void getGroupedDataSets(SoState* state, std::vector<SoLDM::DataSetIdPairList>& dataSets);

  /** Get DataSet Group given their LDMMediator */
  static void getDataSetGroup(SoState* state, SoLDM::DataSetIdPairList& pairList, SoLDMMediator* mediator);

  /** Returns the model matrix of the given DataSet id pair */
  static const SbMatrix& getDataSetModelMatrix(SoState* state, const SoLDM::DataSetIdPair& idPair, SbBool& isIdent);

  /** Defines the dataset id to use for Slices, ROIs, etc. NULL if not set */
  static void setMasterId(SoState* state, int dataSetId);

  /** Defines the dataset to use for Slices, ROIs, etc. NULL if not set */
  static void setMasterIdPair(SoState* state, const SoLDM::DataSetIdPair& idPair);

  /** @see setMasterIdPair() */
  static const SoLDM::DataSetIdPair& getMasterIdPair(SoState* state);

  /** @see setMasterIdPair() */
  static const SoLDM::DataSetIdPair& getInternalMasterIdPair(SoState* state);

  /** Returns the first DataSet of the Mediator that contains the dataset of given ID */
  static int getFirstDataSetId(const SoLDM::DataSetIdPairList& idPairList, int dataSetId);

  /** Returns the last DataSet on state that has the given ID */
  static const SoLDM::DataSetIdPair getLastDataSetWithId(SoState* state, int id);

protected:
  typedef std::set<const SoDataSetId*> DataSetIdSet;
  typedef std::map<SoDataSet*, DataSetIdSet> DataSetIdMap;  
  typedef std::vector<DataSetPtrIdPair> DataSetPtrIdPairVec;
  typedef std::map<SoLDM::DataSetIdPair, SbMatrix> ModelMatrixMap;

  virtual void setElt( SoState* state, SoDataSet* ds );
  virtual void setElt( SoState* state, SoDataSet* ds, const SbMatrix &matrix );

  virtual ~SoDataSetElement() ;

SoINTERNAL protected:
  const SoLDM::DataSetIdPair& getMasterIdPair() const;

private:
  /**
   * Return the dataset of the given type currently on state
   * If derived is true, a derived class can be returned
   */
  static SoLDM::DataSetIdPair getLastOfType(SoState* state, SoType type, bool derived);

  //List of volume data and their ids
  DataSetPtrIdPairVec m_dataSetIdPairList;
  ModelMatrixMap m_modelMatrices;

  SbMatrix      m_modelMatrix;
  SbBool        m_isModelIdentity;
  SoLDM::DataSetIdPair m_datasetNode;
  SoLDM::DataSetIdPair m_masterPair;
  static bool s_forceOIV6Behavior;
  std::vector<uint64_t> m_nodeIds;
};

#ifdef _MSC_VER
#pragma warning( pop )
#endif

#endif // _SO_DATA_SET_ELEMENT_


