/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_DATASETID_ELEMENT
#define  _SO_DATASETID_ELEMENT

#include <Inventor/elements/SoReplacedElement.h>

class SoDataSetId;

/**
 * Stores the current dataset id.
 *
 * @ingroup LDMElements
 *
 * @DESCRIPTION
 * This element stores the dataset id.
 *
 * @SEE_ALSO
 * SoDataSetId, SoDataSet
 */

SoEXTENDER_Documented class LDM_API SoDataSetIdElement : public SoReplacedElement
{
  SO_ELEMENT_HEADER(SoDataSetIdElement);

 public:
  /**
   * Sets the current id in the state.
   */
  static void set(SoState *state, SoDataSetId* dsId);

  /**
   * Returns current id from the state.
   */
  static const SoDataSetId* get(SoState *state);

protected:

  /** Initializes element */
  virtual void init(SoState *state);

 SoINTERNAL public:
  // Initializes the SoDataSetIdElement class
  static void         initClass();
  static void         exitClass();

 protected:
  virtual ~SoDataSetIdElement();

private:
  /**
   * Returns the default id.
   */
  static SoDataSetId*  getDefault() { return NULL; }

  /** Set data id node */
  void setElt(SoDataSetId* dsId);

  SoDataSetId* m_dsId;

};

#endif /* DATASETID_ELEMENT */


