/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Jerome Hummel (Nov 2004)
**=======================================================================*/

  
#ifndef  _SO_WEIGHT_PROP_ELT_
#define  _SO_WEIGHT_PROP_ELT_

#include <Inventor/elements/SoReplacedElement.h>

class SoGeometryPriority;

/**
 * @ingroup LDMElements
 */
class LDM_API SoGeometryPriorityElement : public SoReplacedElement {
  SO_ELEMENT_HEADER( SoGeometryPriorityElement );

public:

  // Sets/Gets the current volume data attributes in the state
  static void set(SoState* state, SoNode *node, SoGeometryPriority *m_geometryPriorityNode);
  static void get(SoState* state, SoGeometryPriority *&m_geometryPriorityNode);

  // Default values
  static void getDefault(SoGeometryPriority *&m_geometryPriorityNode);

protected:

  /** Initializes element */
  virtual void init(SoState* state);

  SoINTERNAL public:
  // Initializes the SoVolumeData class
  static void initClass();
  static void exitClass();

protected:
  virtual void setElt( SoGeometryPriority *m_geometryPriorityNode );

  virtual ~SoGeometryPriorityElement() ;

private:
  SoGeometryPriority* m_geometryPriorityNode;
};

#endif // _SO_WEIGHT_PROP_ELT_


