/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2025 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_HARDWARE_QUERY_
#define  _SO_HARDWARE_QUERY_

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4251)
#pragma warning(disable:4244)
#endif

#include <Inventor/nodes/SoNode.h>

class LDM_API SoHardwareQuery : public SoNode {
  SO_NODE_ABSTRACT_HEADER( SoHardwareQuery );

 public:
  ////////////////////////////////////////////////////////////////////////////////
  // Hardware Query section
   SoHardwareQuery();

  enum HW_Feature {
  /**
   *  The system supports OpenGL 3D texture mapping.
   * On some boards, this query may return TRUE even
   * if your board does not support accelerated
   * 3D textures. In this case performance may
   * be slow, and you may prefer to use
   * 2D textures instead. Note: The inability
   * to determine if 3D textures are accelerated 
   * is a limitation of OpenGL, not Open Inventor.
   */
    HW_3DTEXMAP,
  /**
   *  The system supports the OpenGL paletted
   *  texture extension and/or the texture color table
   *  extension. 
   */
    HW_TEXCOLORMAP,
  /**
   *  The system supports the OpenGL texture
   *  compression extension.
   */
    HW_TEXCOMPRESSION
  };
  enum HW_SupportStatus {
    NO,
    YES,
    UNKNOWN
  };

  /**
   * Returns information about hardware support for various volume rendering
   * features. This query is only valid after SoVolumeRendering::init has been
   * called. Otherwise the return value will be UNKNOWN.
   * When using a debug build of Open Inventor, some "no context available"
   * warning messages may be generated. You can ignore them or see
   * SoGLExtension for an example of using SoGLContext to avoid them.
   */
  static HW_SupportStatus isSupported( HW_Feature feature );

  SoINTERNAL public:
    static void initClass();
    static void exitClass();
};

#ifdef _WIN32
#pragma warning( pop )
#endif

#endif // _SO_HARDWARE_QUERY_


