/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_LDM_SHAPE
#define  _SO_LDM_SHAPE

#include <Inventor/nodes/SoNode.h>
#include <Inventor/nodes/SoShape.h>

#include <LDM/SoLDMTileID.h>

class SoLDMNodeFrontManager;
class SoLdmValuationAction;

/**
* @LDMEXT Abstract base class for LDM shape nodes.
*
* @ingroup LDMNodes
*
* @DESCRIPTION
* Interface for all rendering nodes using LDM
*
* @FILE_FORMAT_DEFAULT
*    LdmShape {
*    @TABLE_FILE_FORMAT
*    @TABLE_END
*    }
*
* @SEE_ALSO
*    SoVolumeRender,
*    SoOrthoSlice,
*    SoObliqueSlice
*
* @ACTION_BEHAVIOR
* SoCallbackAction,
* SoGLRenderAction,
* SoGetBoundingBoxAction,
* SoPickAction,
* SoWriteAction
*
*
*/
class LDM_API SoLdmShape : public SoShape
{
  SO_NODE_ABSTRACT_HEADER(SoLdmShape);

SoINTERNAL public:
  static void initClass();
  static void exitClass();

  /**
   * Returns true if the shape intersects the given tile. @BR
   * Default implementation always returns true.
   */
  virtual bool intersect( SoLDMNodeFrontManager* nfm, const SoLDMTileID& tileId );

protected:
  friend class SoLDMNodeFrontMgrOctree;

  SoLdmShape();
  virtual ~SoLdmShape();

  friend class SoLdmValuationAction;

SoINTERNAL protected:

  /** Return number of allowed 2D texture for this shape */
  virtual unsigned int getSumOfMaxTextures2D( SoLDMNodeFrontManager* nfm );

  /** Register ldm nodes */
  virtual void ldmAction( SoLdmValuationAction* SO_UNUSED_PARAM(action) ) {}

};

#endif // _SO_LDM_SHAPE
