/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#if !defined SOCPUBUFFERASYNCBASICPROPERTY_H
#define SOCPUBUFFERASYNCBASICPROPERTY_H

// LDM include
#include <LDM/tiles/SoCpuBufferBasicProperty.h>
#include <LDM/tiles/SoBufferPropertiesInterface.h>
#include <LDM/tiles/SoBufferAsyncInterface.h>

/**
* @LDMEXT LDM buffer object handling basic LDM tile information and implementing asynchronous buffer interface.
*
* @ingroup LDMTiles
*
* @DESCRIPTION
* This type of buffer represents a standard LDM tile.
*
* @SEE_ALSO
*    SoBufferAsyncInterface, SoBufferPropertiesInterface, SoCpuBufferObject,
*    SoCpuBufferUniform, SoCpuBufferCompressed
*/
class LDM_API SoCpuBufferAsyncBasicProperty: public SoCpuBufferBasicProperty, public SoBufferAsyncInterface
{
  SO_TYPED_CLASS_HEADER();

  // ----------------------- Public usage --------------------------------------
public:

  /** Default constructor. */
  SoCpuBufferAsyncBasicProperty();

  /** Return TRUE if the data attached to this buffer are not currently available */
  virtual bool isInMemory() { return false; }

  /** 
   * Ask to initiate an ansynchronous load of the data if not already in memory.
   *
   * Application must call asyncNotifier->resourceChangeNotify()
   * In order to let LDM for example know that some new data are available. 
   */
  virtual void requestRefetch(SoBufferAsyncNotifierInterface* asyncNotifier, const double weight);

protected:

  /** Destructor. */
  virtual ~SoCpuBufferAsyncBasicProperty();

private:

};

#endif //SOCPUBUFFERASYNCBASICPROPERTY_H

