///////////////////////////////////////////////////////////////////////////////
//
// This class is part of the Open Inventor Medical utility library.
//
// The medical utility classes are provided as a prebuilt library named
// "fei_inventor_medical", that can be used directly in an Open Inventor
// application. The classes in the prebuilt library are documented and
// supported by Thermo Fisher Scientific. These classes are also provided as source code.
//
// The medical utility library provides useful solutions for some specific
// requirements of Open Inventor-based medical visualization applications.
// Compared to typical core Open Inventor classes, medical utility library
// classes may have some limitations. However application developers can use
// the source code to examine, modify or extend these classes according to
// the terms below.
//
// Thermo Fisher Scientific may implement similar classes in core Open Inventor in the future,
// but Thermo Fisher Scientific will continue to support the medical utility version of the class.
//
// Open Inventor customers may use the provided source code to help debug
// their Open Inventor-based application's use of the medical utility library.
//
// Open Inventor customers may use the source code to create new classes,
// derived from the library classes, for use in an Open Inventor application.
// Thermo Fisher Scientific considers such classes to be application code and not supported by Thermo Fisher Scientific.
//
// Open Inventor customers may modify the source code to create customized
// versions of library classes for use in an Open Inventor application. Thermo Fisher Scientific
// considers such classes to be application code and not supported by Thermo Fisher Scientific.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef  _INVENTOR_MEDICAL_
#define  _INVENTOR_MEDICAL_

#if defined(_WIN32) && defined(_MSC_VER)
  #pragma warning( push )
  #pragma warning(disable:4251)
#endif

#include <Inventor/sys/port.h>

#ifdef _WIN32
#  if defined(_DEBUG)
#    define __MEDICALLIB "fei_inventor_medicalD.lib"
#  else
#    define __MEDICALLIB "fei_inventor_medical.lib"
#  endif
#  ifndef InventorMedical_EXPORTS
#    ifndef OIV_DISABLE_AUTOLINK
#      pragma comment(lib, __MEDICALLIB)
#    endif
#  endif
#endif

/**
 * @VSGEXT @PREVIEWTAG @OIVMETAG Initializes the Open Inventor Medical classes.
 * 
 * @ingroup Medical
 * 
 * @DESCRIPTION
 *   This class allows the application to conveniently initialize all
 *   classes in the Open Inventor Medical utility library.
 *
 *   The init() method must be called before creating any Medical nodes.
 *   The finish() method should be called when the application is shutting down.
 *
 * NOTE:
 *
 * The init() method automatically set the environment variable LDM_USE_BUILDTILE_BY_SLICE
 * to 1. (build tiles by requesting full slices from the reader).
 * This value is generally better for medical applications, but it may be not appropriate
 * for your application.
 *
 * @SEE_ALSO
 *  DicomInfo,
 *  Gnomon,
 *  Magnifier,
 *  MedicalHelper,
 *  PlaneBoxIntersection,
 *  PlaneGeometryIntersection,
 *  Ruler,
 *  SceneView,
 *  SliceOrientationMarkers,
 *  SliceScaleBar,
 *  TextBox,
 *  ViewManager,
 *  VolumeMarchingCubes
 * 
 * @PREVIEWFEATURES
 */ 

class INVENTORMEDICAL_API InventorMedical {

public:

   /**
    * Initializes all Open Inventor Medical classes.
    * This function should be called after initializing Open Inventor
    * but before creating any Medical nodes.
    */
   static void init();

   /**
   * Frees Open Inventor's internal static memory 
   * allocations. This avoids false positives from memory
   * leak checking software. We recommend calling this method
   * and it should be the last Open Inventor method called by
   * the application.
   */
   static void finish();

  /**
   * Returns TRUE if module is currently initialized.
   */
  static bool isInitialized();

  /**
   * Constructor.
   */
  InventorMedical();

private:
   static int s_initRefCount;
};

#endif
