///////////////////////////////////////////////////////////////////////////////
//
// This class is part of the Open Inventor Medical utility library.
//
// The medical utility classes are provided as a prebuilt library named
// "fei_inventor_medical", that can be used directly in an Open Inventor
// application. The classes in the prebuilt library are documented and
// supported by Thermo Fisher Scientific. These classes are also provided as source code.
//
// Please see $OIVHOME/include/Medical/InventorMedical.h for the full text.
//
///////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
//
// ObliqueSliceBorder
//
/////////////////////////////////////////////////////////////////////

#ifndef _OBLIQUE_SLICE_BORDER_H_
#define _OBLIQUE_SLICE_BORDER_H_

#include <Medical/InventorMedical.h>
#include <Inventor/fields/SoSFBool.h>
#include <Inventor/fields/SoSFColor.h>

#include <VolumeViz/nodes/SoObliqueSlice.h>

class SoSeparator;
class PlaneBoxIntersection;

/**
 * @VSGEXT @PREVIEWTAG @OIVMETAG Oblique slice shape node with border.
 *
 * @ingroup MedicalNodes
 *
 * @DESCRIPTION
 *   This node is a subclass of SoObliqueSlice. It defines an oblique slice.
 *
 *   In addition to the standard features of SoObliqueSlice, this node can render
 *   a #border around the slice using the specified #borderColor.
 *
 *   The border color can be used, for example, to help the user distinguish
 *   between multiple slices. Another use is to change the border color when a
 *   slice is selected or an interaction begins (see SoDragger addStartCallback).
 *
 * @FILE_FORMAT_DEFAULT
 *    ObliqueSliceBorder {
 *    @TABLE_FILE_FORMAT
 *       @TR dataSetId       @TD 0
 *       @TR plane           @TD 0, 0, 1, 0
 *       @TR interpolation   @TD LINEAR
 *       @TR alphaUse        @TD ALPHA_BINARY
 *       @TR useRGBA         @TD FALSE
 *       @TR alternateRep    @TD NULL
 *       @TR enableBumpMapping @TD FALSE
 *       @TR bumpScale       @TD 1.0
 *       @TR border          @TD TRUE
 *       @TR borderColor     @TD 1 0.5 0
 *    @TABLE_END
 *    }
 *
 * @SEE_ALSO
 *    InventorMedical,
 *    SoOrthoSlice,
 *    SoObliqueSlice,
 *    PlaneBoxIntersection
 *
 * @PREVIEWFEATURES
 */ 

class INVENTORMEDICAL_API ObliqueSliceBorder : public SoObliqueSlice {

  SO_NODE_HEADER(ObliqueSliceBorder);

 public:

  /** Enable the border. Default is true. */
  SoSFBool   border;

  /** Border color.  Default is orange (1, 0.5 0). */
  SoSFColor  borderColor;

  /** Initialize the class. */
  static void   initClass();

  /** Finish using the class. */
  static void   exitClass();

  /** Constructor. */
  ObliqueSliceBorder();

 protected:

  /** Destructor. */
  virtual ~ObliqueSliceBorder();

  /** Called by SoGLRenderAction. */
  virtual void GLRender(SoGLRenderAction* action);

  SoRef<SoSeparator>          m_scene;
  SoRef<PlaneBoxIntersection> m_geometry;
};

#endif //ObliqueSliceBorder