/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _PO_MESHLevelSurf_
#define  _PO_MESHLevelSurf_

#include <MeshViz/3Ddata/PoMesh3D.h>


class PbIndexedMesh3D;
class PbTetrahedronMesh3D;
class PbHexahedronMesh3D;
class PbGrid3D;

class SoMFInt32;
class SbVec3f;

/**
 * @DTEXT  Representation of level surface of volume mesh.
 * 
 * @ingroup MeshRepresentation
 * 
 * @DESCRIPTION
 *    This class represents a 3D level surface of the current volume
 *    mesh. See PoMesh for more explanations about the current mesh.
 *    
 *    The geometry of the level surface is defined by interpolation relating
 *    to the set of scalar values of which index is defined by the field
 *    valuesIndexForLevel. However, if valuesIndexForLevel = -1, the set of
 *    scalar values is the one of which index is PoMesh::valuesIndex. If
 *    this scalar value set does not exist in the current mesh, the 
 *    representation is empty.
 * 
 *    If the field PoMesh::valuesIndex is not defined (or if coloringType = 
 *    COLOR_INHERITED), the representation uses only one inherited color. If the 
 *    field PoMesh::valuesIndex is defined (and if coloringType != COLOR_INHERITED),
 *    the representation is colored by using the current data mapping applied to 
 *    each mesh node value. (see PoMesh for more explanations about the current
 *    data-mapping).
 * 
 *    NOTE : This class is not designed to build an isosurface with
 *    a "per cell" data set : When #valuesIndexForLevel refers to a data set with 
 *    a "PER_CELL" data binding (see PbMesh::DataBinding), the result is unpredictable.
 *    However, an isosurface can be built with a "PER_NODE" data set, and colored
 *    using a "PER_CELL" data set : when #valuesIndexForLevel refers to a PER_NODE data set and
 *    #valuesIndex refers to a PER_CELL data set, a valid isosurface is built.
 *    
 *    The vector data of the mesh for this representation is unused.
 * 
 *    The isosurface can be generated by using either a triangle strip set or 
 *    an indexed face set depending on the preference variable 
 *    SoPreference#OIV_3DDATA_USE_TRIANGLE_STRIP_SET
 * 
 * @FILE_FORMAT_DEFAULT
 *    PoMeshLevelSurf {
 *    @TABLE_FILE_FORMAT
 *       @TR levelValue @TD 0.0
 *       @TR surfOrientation @TD ORIENTED_TO_MAX
 *       @TR valuesIndexForLevel @TD -1
 *       @TR valuesIndex @TD -1
 *       @TR coloringType @TD COLOR_INHERITED
 *       @TR vecsIndex @TD -1
 *       @TR valuesIndexForCellFilter  @TD -1
 *       @TR moduleDataMapping @TD NULL
 *    @TABLE_END
 *    }
 * 
 * @CATALOG_PARTS_INCLUDE pomeshlevelsurf.cat.html
 * 
 * 
 */
class MESHVIZ_API PoMeshLevelSurf : public PoMesh3D {

  SO_KIT_HEADER(PoMeshLevelSurf);

  /* Define fields for new parts */
  SO_KIT_CATALOG_ENTRY_HEADER(groupLevelSurf);

 public:

  /**
   * Constructor.
   */
  PoMeshLevelSurf();

  /**
   * Forces node-kit rebuilding. See PoBase.
   */
  virtual void rebuild();

  /**
   *  Type of level surface orientation.
   */
  enum SurfOrientation {
    ORIENTED_TO_MIN,
    ORIENTED_TO_MAX
  };

  /* Fields */

  /**
   * Orientation of the level surface
   *
   * #ORIENTED_TO_MIN: The facet normals of the level surface are oriented 
   * to the region of the mesh where the values are less than levelValue.
   * 
   * #ORIENTED_TO_MAX: The facet normals of the level surface are 
   * oriented to the region of the mesh where the values are greater than 
   * levelValue.
   * These normal orientations are respected if each element of the mesh respects 
   * the orientation rules (see the definition of each type of mesh).
   */
  SoSFEnum surfOrientation;        

  /**
   * Value of the level surface.
   */
  SoSFFloat levelValue;

  /**
   * Index of the set of value used to compute the level surface.
   * If valuesIndexForLevel == -1, this index is defined by PoMesh::valuesIndex.
   * -1 by default.
   */
  SoSFInt32 valuesIndexForLevel;    

  /*----------------------------------------------------------------------------*/
 PoINTERNAL public:

  static void initClass();
	static void exitClass() ;

  const float *getIsosurfDataSet();
  float getIsosurfValue() const;
  int getSurfOrientation() { return surfOrientation.getValue(); }

 protected:

  // Methods
  virtual void setDefaultOnNonWritingFields();
  virtual SbBool setUpConnections(SbBool onOff, SbBool doItAlways = FALSE);
  virtual void addElementsAllCaches();
  virtual void preRebuild();
  // Destructor
  virtual ~PoMeshLevelSurf();  

  virtual int getIsosurfDataSetId() const;
  virtual int getIsosurfDataSetIndex() const;
  /*----------------------------------------------------------------------------*/
 private:
  
  // Sensors
  FieldSensorList m_fieldSensorList;

  // List of fields defined in this class
  SoFieldList m_fieldList;

  uint32_t m_isoDataSetId;    // State of the data set used by the last rebuilt
};

/*----------------------------------------------------------------------------*/

#endif /* _PO_MESHLEVELSURF_ */



