/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : R. ALBOU (Mar 1999)
**=======================================================================*/

                                                             /* include files */
#ifndef  _PO_BEVEL_EDGE_ELEMENT_
#define  _PO_BEVEL_EDGE_ELEMENT_

#include <Inventor/elements/SoReplacedElement.h>

#include <MeshViz/nodes/PoBevelEdge.h>

/**
 * @ingroup MeshVizElements
 */
class MESHVIZ_API PoBevelEdgeElement : public SoReplacedElement {

  SO_ELEMENT_HEADER(PoBevelEdgeElement);
  
 public:
  // Set the current beveled edge attributes
  static void set(SoState *state, SoNode *node, SbBool on, float radius,
                  PoBevelEdge::RadiusFlag radiusFlag, float bevelAngle);
  
  // Return the current beveled edge attributes from the state
  static void get(SoState *state, SbBool &on, float &radius,
                  PoBevelEdge::RadiusFlag &radiusFlag, float &bevelAngle);
  
  // Default values
  static void getDefault(SbBool &on, float &radius, 
                         PoBevelEdge::RadiusFlag &radiusFlag, 
                         float &bevelAngle);
  
 SoINTERNAL public:
  // Initializes the class
  static void initClass();
	static void exitClass() ;
  
 protected:
  /** @copydoc SoElement::init */
  virtual void init(SoState *state);

  virtual ~PoBevelEdgeElement();
  
 private:
  SbBool m_on;
  float m_radius, m_bevelAngle;
  PoBevelEdge::RadiusFlag m_radiusFlag;
};
/*----------------------------------------------------------------------------*/

#endif // _PO_BEVEL_EDGE_ELEMENT_


