/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : R. ALBOU (Jan 1998)
**=======================================================================*/

                                                             /* include files */
#ifndef  _PO_DATA_MAPPING_ELEMENT_
#define  _PO_DATA_MAPPING_ELEMENT_

#include <Inventor/elements/SoReplacedElement.h>
#include <MeshViz/graph/PbLinearDataMapping.h>

class PbDataMapping;

/**
 * @ingroup MeshVizElements
 */
class MESHVIZ_API PoDataMappingElement : public SoReplacedElement {

  SO_ELEMENT_HEADER(PoDataMappingElement);
  
 public:  
  // set the current dataMapping
  static void set(SoState *state, SoNode *node,
                  const PbDataMapping *dataMapping);
  
  // return the current data mapping from the state
  static const PbDataMapping *get(SoState *state);
  
 SoINTERNAL public:
  // Initializes the class
  static void initClass();
	static void exitClass() ;
  
 protected:
  PbDataMapping *m_dataMapping;
  
  /** @copydoc SoElement::init */
  virtual void init(SoState *state);

  virtual ~PoDataMappingElement();
};
/*----------------------------------------------------------------------------*/

#endif // _PO_DATA_MAPPING_ELEMENT_


