/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : R. ALBOU (Jan 1999)
**=======================================================================*/

                                                             /* include files */
#ifndef  _PO_MESH1D_FILTER_ELEMENT_
#define  _PO_MESH1D_FILTER_ELEMENT_


#include <Inventor/elements/SoReplacedElement.h>


class PoMesh1DFilter;

/**
 * @ingroup MeshVizElements
 */
class MESHVIZ_API PoMesh1DFilterElement : public SoReplacedElement {

  SO_ELEMENT_HEADER(PoMesh1DFilterElement);
  
 public:  
  // Set the current mesh 1D filter node
  static void  set(SoState *state, SoNode *node, const PoMesh1DFilter *filter);
  
  // Return the current mesh 1D filter node from the state
  static const PoMesh1DFilter *get(SoState *state);
  
  // Default values
  static PoMesh1DFilter *getDefault() 
    { return NULL; }
  
 SoINTERNAL public:
  // Initializes the class
  static void initClass();
	static void exitClass() ;
  
 protected:
  virtual ~PoMesh1DFilterElement();

  /** @copydoc SoElement::init */
  virtual void init(SoState *state);

 private:
  PoMesh1DFilter *m_mesh1DFilter;
};
/*----------------------------------------------------------------------------*/

#endif // _PO_MESH1D_FILTER_ELEMENT_


